/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.wayfinder.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.potionstudios.wayfinder.PlatformHandler;

class WayfinderDeathsCommand {
    WayfinderDeathsCommand() {
    }

    static LiteralArgumentBuilder<CommandSourceStack> register() {
        LiteralArgumentBuilder deathsCommand = LiteralArgumentBuilder.literal((String)"deaths");
        ((LiteralArgumentBuilder)deathsCommand.requires(commandSourceStack -> PlatformHandler.PLATFORM_HANDLER.hasPermission((CommandSourceStack)commandSourceStack, "wayfinder.commands.deaths.list"))).then(LiteralArgumentBuilder.literal((String)"list").executes(WayfinderDeathsCommand::listDeaths));
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)deathsCommand.executes(WayfinderDeathsCommand::showPlayerDeaths)).requires(commandSourceStack -> PlatformHandler.PLATFORM_HANDLER.hasPermission((CommandSourceStack)commandSourceStack, "wayfinder.commands.deaths.player"))).then(RequiredArgumentBuilder.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(WayfinderDeathsCommand::showSelectedPlayerDeaths));
        ((LiteralArgumentBuilder)deathsCommand.requires(commandSourceStack -> PlatformHandler.PLATFORM_HANDLER.hasPermission((CommandSourceStack)commandSourceStack, "wayfinder.commands.deaths.reset"))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"reset").executes(WayfinderDeathsCommand::resetPlayerDeaths)).then(RequiredArgumentBuilder.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(WayfinderDeathsCommand::resetSelectedPlayerDeaths)));
        return deathsCommand;
    }

    private static int listDeaths(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"wayfinder.commands.deaths.list.start"), false);
        ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayers().forEach(player -> ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"wayfinder.commands.deaths.list.player", (Object[])new Object[]{player.getDisplayName(), PlatformHandler.PLATFORM_HANDLER.getWayfinderDeaths((Player)player)}), false));
        return 1;
    }

    private static int showSelectedPlayerDeaths(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(context, (String)"player");
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"wayfinder.commands.deaths.show.other", (Object[])new Object[]{player.getDisplayName(), PlatformHandler.PLATFORM_HANDLER.getWayfinderDeaths((Player)player)}), false);
        return 1;
    }

    private static int showPlayerDeaths(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"wayfinder.commands.deaths.show.self", (Object[])new Object[]{PlatformHandler.PLATFORM_HANDLER.getWayfinderDeaths((Player)player)}), false);
        return 1;
    }

    private static int resetSelectedPlayerDeaths(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(context, (String)"player");
        PlatformHandler.PLATFORM_HANDLER.resetWayfinderDeaths((Player)player);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"wayfinder.commands.deaths.reset.other", (Object[])new Object[]{player.getDisplayName()}).withStyle(ChatFormatting.GREEN), true);
        return 1;
    }

    private static int resetPlayerDeaths(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        PlatformHandler.PLATFORM_HANDLER.resetWayfinderDeaths((Player)player);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"wayfinder.commands.deaths.reset.self", (Object[])new Object[]{player.getDisplayName()}).withStyle(ChatFormatting.GREEN), true);
        return 1;
    }
}

