/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.wayfinder.forge;

import com.google.auto.service.AutoService;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.luckperms.api.LuckPermsProvider;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import net.potionstudios.wayfinder.PlatformHandler;
import net.potionstudios.wayfinder.forge.networking.ForgeNetworking;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.network.packet.MultiloaderPacket;

@AutoService(value={PlatformHandler.class})
public final class ForgePlatformHandler
implements PlatformHandler {
    private static final boolean luckPerms = ModList.get().isLoaded("luckperms");
    private static final Map<ResourceKey<?>, DeferredRegister> CACHED = new Reference2ObjectOpenHashMap();

    @Override
    public Path configPath() {
        return FMLPaths.CONFIGDIR.get().resolve("wayfinder");
    }

    @Override
    public boolean hasPermission(@NotNull CommandSourceStack sourceStack, @NotNull String permission) {
        return PlatformHandler.super.hasPermission(sourceStack, permission) || luckPerms && LuckPermsProvider.get().getUserManager().getUser(sourceStack.getPlayer().getUUID()).getCachedData().getPermissionData().checkPermission(permission).asBoolean();
    }

    @Override
    public Supplier<SpawnEggItem> createSpawnEgg(Supplier<EntityType<? extends Mob>> entity, int backgroundColor, int highlightColor) {
        return () -> new ForgeSpawnEggItem(entity, backgroundColor, highlightColor, new Item.Properties());
    }

    @Override
    public <T> Supplier<T> register(Registry<? super T> registry, String name, Supplier<T> value) {
        return CACHED.computeIfAbsent(registry.key(), key -> DeferredRegister.create((ResourceLocation)registry.key().location(), (String)"wayfinder")).register(name, value);
    }

    @Override
    public <T> Supplier<Holder.Reference<T>> registerForHolder(Registry<T> registry, String name, Supplier<T> value) {
        RegistryObject registryObject = CACHED.computeIfAbsent(registry.key(), key -> DeferredRegister.create((ResourceLocation)registry.key().location(), (String)"wayfinder")).register(name, value);
        return () -> (Holder.Reference)registryObject.getHolder().get();
    }

    @Override
    public boolean hasWayfinder(Player player) {
        return player.getPersistentData().hasUUID("wayfinder") && PlatformHandler.super.hasWayfinder(player);
    }

    @Override
    public void setWayfinder(Player player, UUID wayfinder) {
        player.getPersistentData().putUUID("wayfinder", wayfinder);
    }

    @Override
    public UUID getWayfinder(Player player) {
        return player.getPersistentData().getUUID("wayfinder");
    }

    @Override
    public int getWayfinderDeaths(Player player) {
        return player.getPersistentData().getInt("wayfinder_deaths");
    }

    @Override
    public void incrementWayfinderDeaths(Player player) {
        player.getPersistentData().putInt("wayfinder_deaths", this.getWayfinderDeaths(player) + 1);
    }

    @Override
    public void resetWayfinderDeaths(Player player) {
        player.getPersistentData().putInt("wayfinder_deaths", 0);
    }

    @Override
    public void increment3kJourneys(Player player) {
        player.getPersistentData().putInt("3k_journeys", this.get3kJourneys(player) + 1);
    }

    @Override
    public int get3kJourneys(Player player) {
        return player.getPersistentData().getInt("3k_journeys");
    }

    @Override
    public void sendToPlayer(MultiloaderPacket packet, Player player) {
        ForgeNetworking.sendToPlayer(packet, (ServerPlayer)player);
    }

    @Override
    public void sendToServer(MultiloaderPacket packet) {
        ForgeNetworking.sendToServer(packet);
    }

    public static void register(IEventBus bus) {
        CACHED.values().forEach(deferredRegister -> deferredRegister.register(bus));
    }
}

