/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.wayfinder.forge;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.potionstudios.wayfinder.Wayfinder;
import net.potionstudios.wayfinder.commands.WayfinderCommands;
import net.potionstudios.wayfinder.forge.ForgePlatformHandler;
import net.potionstudios.wayfinder.forge.client.WayfinderClientForge;
import net.potionstudios.wayfinder.forge.networking.ForgeNetworking;
import net.potionstudios.wayfinder.world.item.WayfinderItems;
import net.potionstudios.wayfinder.world.level.block.WayfinderBlocks;

@Mod(value="wayfinder")
public class WayfinderForge {
    public WayfinderForge(FMLJavaModLoadingContext context) {
        IEventBus MOD_BUS = context.getModEventBus();
        IEventBus EVENT_BUS = MinecraftForge.EVENT_BUS;
        Wayfinder.init();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> WayfinderClientForge.init(MOD_BUS));
        ForgePlatformHandler.register(MOD_BUS);
        MOD_BUS.addListener(event -> Wayfinder.registerEntityAttributes((arg_0, arg_1) -> ((EntityAttributeCreationEvent)event).put(arg_0, arg_1)));
        EVENT_BUS.addListener(event -> WayfinderCommands.register(arg_0 -> ((CommandDispatcher)event.getDispatcher()).register(arg_0)));
        MOD_BUS.addListener(event -> {
            if (event.getTabKey() == CreativeModeTabs.SPAWN_EGGS) {
                event.accept((ItemLike)WayfinderItems.WAYFINDER_SPAWN_EGG.get());
            } else if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
                event.accept((ItemLike)WayfinderBlocks.WAYFINER_HEART.get());
            } else if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
                event.accept((ItemLike)WayfinderItems.MUSIC_DISC_SWEET_DREAMS.get());
            }
        });
        EVENT_BUS.addListener(event -> Wayfinder.onEntityLoad(event.getEntity()));
        ForgeNetworking.init();
    }
}

