/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.wayfinder.forge.networking;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.payload.PayloadFlow;
import net.minecraftforge.network.payload.PayloadProtocol;
import net.potionstudios.wayfinder.Wayfinder;
import net.potionstudios.wayfinder.network.protocol.WayfinderNetworking;
import software.bernie.geckolib.network.packet.MultiloaderPacket;

public class ForgeNetworking {
    private static final int PROTOCOL_VERSION = 1;
    public static final PayloadProtocol<RegistryFriendlyByteBuf, CustomPacketPayload> INSTANCE = ChannelBuilder.named((ResourceLocation)Wayfinder.id("main")).networkProtocolVersion(1).optional().payloadChannel().play();
    public static Channel<CustomPacketPayload> CHANNEL;

    public static <P extends MultiloaderPacket> void init() {
        CHANNEL = ((PayloadFlow)INSTANCE.bidirectional()).build();
        WayfinderNetworking.registerS2CPackets(ForgeNetworking::registerS2CPackets);
        WayfinderNetworking.registerC2SPackets(ForgeNetworking::registerC2SPackets);
    }

    private static <B extends FriendlyByteBuf, P extends MultiloaderPacket> void registerS2CPackets(CustomPacketPayload.Type<P> type, StreamCodec<B, P> codec) {
        ((PayloadFlow)INSTANCE.clientbound()).add(type, codec, (packet, context) -> {
            packet.receiveMessage((Player)context.getSender(), arg_0 -> ((CustomPayloadEvent.Context)context).enqueueWork(arg_0));
            context.setPacketHandled(true);
        });
    }

    private static <B extends FriendlyByteBuf, P extends MultiloaderPacket> void registerC2SPackets(CustomPacketPayload.Type<P> type, StreamCodec<B, P> codec) {
        ((PayloadFlow)INSTANCE.serverbound()).add(type, codec, (packet, context) -> {
            packet.receiveMessage((Player)context.getSender(), arg_0 -> ((CustomPayloadEvent.Context)context).enqueueWork(arg_0));
            context.setPacketHandled(true);
        });
    }

    public static void sendToPlayer(MultiloaderPacket packet, ServerPlayer player) {
        CHANNEL.send((Object)packet, PacketDistributor.PLAYER.with((Object)player));
    }

    public static void sendToServer(MultiloaderPacket packet) {
        CHANNEL.send((Object)packet, PacketDistributor.SERVER.noArg());
    }
}

