/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.wayfinder.world.entity.ai.control;

import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.potionstudios.wayfinder.world.entity.wayfinder.WayfinderEntity;

public class WayfinderMoveControl
extends FlyingMoveControl {
    private final WayfinderEntity wayfinder;
    private final double phaseOffset;

    public WayfinderMoveControl(WayfinderEntity wayfinder, double phaseOffset) {
        super((Mob)wayfinder, 30, true);
        this.wayfinder = wayfinder;
        this.phaseOffset = phaseOffset;
    }

    public void tick() {
        boolean shouldFloatNearOwner;
        double groundY = this.findGroundY();
        double minY = groundY + 0.5;
        double maxY = groundY + 2.0;
        if (this.wayfinder.isSitting()) {
            if (this.wayfinder.isNoGravity()) {
                this.wayfinder.setNoGravity(false);
            }
            if (this.wayfinder.onGround()) {
                this.wayfinder.setDeltaMovement(0.0, 0.0, 0.0);
            }
            return;
        }
        boolean bl = shouldFloatNearOwner = this.wayfinder.getOwner() != null && this.wayfinder.getOwner().distanceToSqr((Entity)this.wayfinder) < 10.0 && this.wayfinder.getTargetBiomeBlockPos().isEmpty() && !this.wayfinder.isScared();
        if (shouldFloatNearOwner) {
            if (!this.wayfinder.isNoGravity()) {
                this.wayfinder.setNoGravity(true);
            }
            double bobOffset = Math.sin((double)this.mob.tickCount * 0.1 + this.phaseOffset) * 0.05;
            double targetY = Mth.clamp((double)(this.wayfinder.getOwner().getY() + bobOffset), (double)minY, (double)maxY);
            double dy = targetY - this.wayfinder.getY();
            this.wayfinder.setDeltaMovement(this.wayfinder.getDeltaMovement().x, dy * 0.3, this.wayfinder.getDeltaMovement().z);
        } else if (this.operation == MoveControl.Operation.MOVE_TO) {
            this.wantedY = Mth.clamp((double)this.wantedY, (double)minY, (double)maxY);
            super.tick();
            if (!this.wayfinder.isNoGravity()) {
                this.wayfinder.setNoGravity(true);
            }
        } else {
            this.mob.setYya(0.0f);
            this.mob.setZza(0.0f);
        }
        if (this.wayfinder.getY() > maxY) {
            this.wayfinder.setPos(this.wayfinder.getX(), maxY, this.wayfinder.getZ());
        }
    }

    private double findGroundY() {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos().set(this.wayfinder.getX(), this.wayfinder.getY(), this.wayfinder.getZ());
        while (pos.getY() > this.wayfinder.level().getMinBuildHeight()) {
            if (!this.wayfinder.level().getBlockState((BlockPos)pos).isAir()) {
                return pos.getY() + 1;
            }
            pos.move(0, -1, 0);
        }
        return this.wayfinder.level().getMinBuildHeight();
    }
}

