/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.wayfinder.world.entity.ai.goal;

import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.potionstudios.wayfinder.PlatformHandler;
import net.potionstudios.wayfinder.Wayfinder;
import net.potionstudios.wayfinder.advancements.critereon.WayfinderCriteriaTriggers;
import net.potionstudios.wayfinder.world.entity.wayfinder.WayfinderEntity;
import org.jetbrains.annotations.Nullable;

public class GoToPosGoal
extends Goal {
    private final WayfinderEntity wayfinder;
    private Optional<BlockPos> target;
    @Nullable
    private LivingEntity owner;
    private final double speed;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private int teleportWaitTime;
    private int distance;

    public GoToPosGoal(WayfinderEntity wayfinder, @Nullable LivingEntity owner, Optional<BlockPos> target, double speed) {
        this.wayfinder = wayfinder;
        this.target = target;
        this.owner = owner;
        this.speed = speed;
        this.navigation = wayfinder.getNavigation();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public boolean canUse() {
        LivingEntity livingEntity = this.wayfinder.getOwner();
        Optional<BlockPos> target = this.wayfinder.getTargetBiomeBlockPos();
        if (livingEntity == null || target.isEmpty()) {
            return false;
        }
        this.owner = livingEntity;
        this.target = target;
        return true;
    }

    public void start() {
        this.timeToRecalcPath = 0;
        this.teleportWaitTime = Wayfinder.CONFIG.wayfinder.TELEPORT_TO_OWNER.value() * 20;
        this.distance = this.wayfinder.blockPosition().distManhattan((Vec3i)this.target.get());
    }

    public void stop() {
        this.owner = null;
        this.navigation.stop();
        this.wayfinder.setTargetBlockPos(Optional.empty());
    }

    public void tick() {
        Level level;
        Holder biome;
        if (this.owner.blockPosition().distManhattan((Vec3i)this.wayfinder.blockPosition()) >= 200) {
            this.navigation.stop();
            this.timeToRecalcPath = 0;
            --this.teleportWaitTime;
            if (this.teleportWaitTime <= 0) {
                this.wayfinder.tryToTeleportToOwner();
            }
        } else if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.adjustedTickDelay(10);
            if (this.navigation.isStuck() || this.navigation.isDone()) {
                this.navigation.moveTo((double)this.target.get().getX(), (double)this.target.get().getY(), (double)this.target.get().getZ(), this.speed);
            }
            this.teleportWaitTime = Wayfinder.CONFIG.wayfinder.TELEPORT_TO_OWNER.value() * 20;
        }
        if ((biome = (level = this.wayfinder.level()).getBiome(this.wayfinder.blockPosition())).is(level.getBiome(this.target.get()))) {
            ServerPlayer owner = (ServerPlayer)this.owner;
            if (this.distance >= 3000) {
                PlatformHandler.PLATFORM_HANDLER.increment3kJourneys((Player)owner);
            }
            WayfinderCriteriaTriggers.WAYFINDER_GOT_TO_BIOME.get().trigger(owner, (ResourceKey<Biome>)((ResourceKey)biome.unwrapKey().orElseThrow()), (ResourceKey<Level>)level.dimension(), this.distance);
            this.wayfinder.playSound(SoundEvents.AMETHYST_BLOCK_RESONATE);
            level.broadcastEntityEvent((Entity)this.wayfinder, (byte)12);
            this.wayfinder.incrementCompletedJourneys();
            this.stop();
        }
    }
}

