/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.wayfinder.world.entity.ai.goal;

import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.potionstudios.wayfinder.Wayfinder;
import net.potionstudios.wayfinder.tags.WayfinderEntityTypeTags;
import net.potionstudios.wayfinder.world.entity.wayfinder.WayfinderEntity;

public class ScaredWayfinderGoal
extends Goal {
    private final WayfinderEntity entity;
    private int ticksToNormal;
    private List<Monster> targets;
    private boolean wasScaredByEntity;

    public ScaredWayfinderGoal(WayfinderEntity entity) {
        this.entity = entity;
        this.targets = List.of();
    }

    public void tick() {
        if (this.entity.isScared()) {
            if (this.wasScaredByEntity && this.targets.stream().allMatch(LivingEntity::isDeadOrDying)) {
                this.entity.setScared(false);
                return;
            }
            if (this.ticksToNormal > 0) {
                --this.ticksToNormal;
            }
        }
        if (this.ticksToNormal == 0 || this.entity.getServer().getTickCount() % 20 == 0) {
            this.refreshTargets();
            if (this.targets.isEmpty()) {
                this.entity.setScared(false);
            }
        }
        if (!this.targets.isEmpty()) {
            this.entity.setScared(true);
            this.wasScaredByEntity = true;
            this.ticksToNormal = 200;
        }
    }

    public boolean canUse() {
        return true;
    }

    public void start() {
        this.ticksToNormal = 200;
        this.wasScaredByEntity = false;
        this.refreshTargets();
    }

    private void refreshTargets() {
        this.targets = this.entity.level().getNearbyEntities(Monster.class, TargetingConditions.forNonCombat().selector(livingEntity -> livingEntity.getType().is(WayfinderEntityTypeTags.SCARES_WAYFINDER)), (LivingEntity)this.entity, this.entity.getBoundingBox().inflate((double)Wayfinder.CONFIG.wayfinder.SCARED_PROJECTILE_MOB_DISTANCE.value().intValue()));
    }
}

