/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.wayfinder.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.potionstudios.wayfinder.PlatformHandler;
import net.potionstudios.wayfinder.Wayfinder;
import net.potionstudios.wayfinder.sounds.WayfinderSounds;
import net.potionstudios.wayfinder.world.entity.block.WayfinderBlockEntityType;
import net.potionstudios.wayfinder.world.entity.block.WayfinderHeartBlockEntity;
import net.potionstudios.wayfinder.world.entity.wayfinder.WayfinderEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WayfinderHeartBlock
extends BaseEntityBlock {
    public static final MapCodec<WayfinderHeartBlock> CODEC = WayfinderHeartBlock.simpleCodec(WayfinderHeartBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final TagKey<Item> EMERALD_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"gems/emerald"));
    public static final BooleanProperty ACTIVATED = BooleanProperty.create((String)"activated");

    public WayfinderHeartBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (level.isClientSide()) {
            return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        }
        if (!((Boolean)state.getValue((Property)ACTIVATED)).booleanValue() && stack.is(EMERALD_TAG) && !PlatformHandler.PLATFORM_HANDLER.hasWayfinder(player)) {
            int cost = WayfinderHeartBlock.getCost(player);
            if (stack.getCount() >= cost) {
                level.scheduleTick(pos, (Block)this, 20 * Wayfinder.CONFIG.wayfinderHeartBlock.ACTIVATION_COOLDOWN.value());
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(true)));
                if (!player.isCreative()) {
                    stack.shrink(cost);
                }
                level.playSound(null, pos, WayfinderSounds.WAYFINDER_SUMMON.get(), SoundSource.BLOCKS);
                WayfinderHeartBlock.spawnWayfinder(level, pos.above(), (ServerPlayer)player);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.FAIL;
    }

    protected void tick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (((Boolean)state.getValue((Property)ACTIVATED)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (((Boolean)state.getValue((Property)ACTIVATED)).booleanValue() && random.nextBoolean()) {
            for (int i = 0; i < random.nextInt(5, 10); ++i) {
                level.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() + 0.5 + (random.nextDouble() - 0.5) * 0.8, (double)pos.getY() + 1.3 + (random.nextDouble() - 0.5) * 0.8, (double)pos.getZ() + 0.5 + (random.nextDouble() - 0.5) * 0.8, (random.nextDouble() - 0.5) * 0.2, random.nextDouble() * 0.1, (random.nextDouble() - 0.5) * 0.2);
            }
        }
    }

    private static void spawnWayfinder(@NotNull Level level, @NotNull BlockPos pos, @NotNull ServerPlayer player) {
        WayfinderEntity wayfinder = new WayfinderEntity(level, (Player)player);
        wayfinder.setPos(pos.getX(), pos.getY() + 1, pos.getZ());
        level.addFreshEntity((Entity)wayfinder);
        CriteriaTriggers.SUMMONED_ENTITY.trigger(player, (Entity)wayfinder);
    }

    private static int getCost(@NotNull Player player) {
        int deaths = PlatformHandler.PLATFORM_HANDLER.getWayfinderDeaths(player);
        if (deaths == 0) {
            return 1;
        }
        return deaths * Math.abs(Wayfinder.CONFIG.wayfinderHeartBlock.EMERALD_DEATH_COST_MULTIPLIER.value());
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ACTIVATED}).add(new Property[]{FACING});
    }

    @NotNull
    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return WayfinderBlockEntityType.WAYFINDER_HEART.get().create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        return WayfinderHeartBlock.createTickerHelper(level, blockEntityType, WayfinderBlockEntityType.WAYFINDER_HEART.get());
    }

    public static <T extends BlockEntity> BlockEntityTicker<T> createTickerHelper(Level level, BlockEntityType<T> serverType, BlockEntityType<? extends WayfinderHeartBlockEntity> clientType) {
        return level.isClientSide() ? null : WayfinderHeartBlock.createTickerHelper(serverType, clientType, WayfinderHeartBlockEntity::serverTick);
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }
}

