/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.wayfinder.world.level.levelgen.structure;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.potionstudios.wayfinder.Wayfinder;
import net.potionstudios.wayfinder.world.level.levelgen.structure.processor.WayfinderStructureProcessorLists;

public class WayfinderTemplatePools {
    public static final Map<ResourceKey<StructureTemplatePool>, TemplatePoolFactory> TEMPLATE_POOL_FACTORIES = new Reference2ObjectOpenHashMap();
    private static final ResourceKey<StructureTemplatePool> PLAINS_SHRINE = WayfinderTemplatePools.register("village/plains/wayfinder_shrine", templatePoolFactoryContext -> WayfinderTemplatePools.createTemplatePool(WayfinderTemplatePools.getPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, (ResourceKey<StructureTemplatePool>)ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"village/plains/houses"))), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)"wayfinder:wayfinder_grassy_shrine", WayfinderTemplatePools.getProcessor((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, WayfinderStructureProcessorLists.PLAINS_SHRINE)), (Object)1)), StructureTemplatePool.Projection.RIGID));
    private static final ResourceKey<StructureTemplatePool> SAVANNA_SHRINE = WayfinderTemplatePools.register("village/savanna/wayfinder_shrine", templatePoolFactoryContext -> WayfinderTemplatePools.createTemplatePool(WayfinderTemplatePools.getPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, (ResourceKey<StructureTemplatePool>)ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"village/savanna/houses"))), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)"wayfinder:wayfinder_grassy_shrine", WayfinderTemplatePools.getProcessor((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, WayfinderStructureProcessorLists.PLAINS_SHRINE)), (Object)1)), StructureTemplatePool.Projection.RIGID));
    private static final ResourceKey<StructureTemplatePool> TAIGA_SHRINE = WayfinderTemplatePools.register("village/taiga/wayfinder_shrine", templatePoolFactoryContext -> WayfinderTemplatePools.createTemplatePool(WayfinderTemplatePools.getPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, (ResourceKey<StructureTemplatePool>)ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"village/taiga/houses"))), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)"wayfinder:wayfinder_taiga_shrine", WayfinderTemplatePools.getProcessor((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, WayfinderStructureProcessorLists.TAIGA_SHRINE)), (Object)1)), StructureTemplatePool.Projection.RIGID));
    private static final ResourceKey<StructureTemplatePool> DESERT_SHRINE = WayfinderTemplatePools.register("village/desert/wayfinder_shrine", templatePoolFactoryContext -> WayfinderTemplatePools.createTemplatePool(WayfinderTemplatePools.getPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, (ResourceKey<StructureTemplatePool>)ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"village/desert/houses"))), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)"wayfinder:wayfinder_desert_shrine", WayfinderTemplatePools.getProcessor((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, WayfinderStructureProcessorLists.DESERT_SHRINE)), (Object)1)), StructureTemplatePool.Projection.RIGID));
    private static final ResourceKey<StructureTemplatePool> SNOWY_SHRINE = WayfinderTemplatePools.register("village/snowy/wayfinder_shrine", templatePoolFactoryContext -> WayfinderTemplatePools.createTemplatePool(WayfinderTemplatePools.getPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, (ResourceKey<StructureTemplatePool>)ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"village/snowy/houses"))), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)"wayfinder:wayfinder_snowy_shrine", WayfinderTemplatePools.getProcessor((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, WayfinderStructureProcessorLists.SNOWY_SHRINE)), (Object)1)), StructureTemplatePool.Projection.RIGID));
    private static final ResourceKey<StructureTemplatePool> RED_ROCK_SHRINE = WayfinderTemplatePools.register("village/red_rock/wayfinder_shrine", templatePoolFactoryContext -> WayfinderTemplatePools.createTemplatePool(WayfinderTemplatePools.getEmptyPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)"wayfinder:wayfinder_red_rock_shrine", WayfinderTemplatePools.getProcessor((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, (ResourceKey<StructureProcessorList>)ProcessorLists.EMPTY)), (Object)1)), StructureTemplatePool.Projection.RIGID));
    private static final ResourceKey<StructureTemplatePool> SALEM_SHRINE = WayfinderTemplatePools.register("village/salem/wayfinder_shrine", templatePoolFactoryContext -> WayfinderTemplatePools.createTemplatePool(WayfinderTemplatePools.getEmptyPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)"wayfinder:wayfinder_salem_shrine", WayfinderTemplatePools.getProcessor((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, (ResourceKey<StructureProcessorList>)ProcessorLists.EMPTY)), (Object)1)), StructureTemplatePool.Projection.RIGID));
    private static final ResourceKey<StructureTemplatePool> SKYRIS_SHRINE = WayfinderTemplatePools.register("village/slyris/wayfinder_shrine", templatePoolFactoryContext -> WayfinderTemplatePools.createTemplatePool(WayfinderTemplatePools.getEmptyPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)"wayfinder:wayfinder_skyris_shrine", WayfinderTemplatePools.getProcessor((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, (ResourceKey<StructureProcessorList>)ProcessorLists.EMPTY)), (Object)1)), StructureTemplatePool.Projection.RIGID));
    private static final ResourceKey<StructureTemplatePool> SWAMPY_SHRINE = WayfinderTemplatePools.register("village/swampy/wayfinder_shrine", templatePoolFactoryContext -> WayfinderTemplatePools.createTemplatePool(WayfinderTemplatePools.getEmptyPool((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)"wayfinder:wayfinder_swampy_shrine", WayfinderTemplatePools.getProcessor((BootstrapContext<StructureTemplatePool>)templatePoolFactoryContext, (ResourceKey<StructureProcessorList>)ProcessorLists.EMPTY)), (Object)1)), StructureTemplatePool.Projection.RIGID));

    private static StructureTemplatePool createTemplatePool(Holder<StructureTemplatePool> fallback, List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>> rawTemplateFactories, StructureTemplatePool.Projection projection) {
        return new StructureTemplatePool(fallback, rawTemplateFactories, projection);
    }

    private static ResourceKey<StructureTemplatePool> register(String id, TemplatePoolFactory factory) {
        ResourceKey templatePoolResourceKey = Wayfinder.key(Registries.TEMPLATE_POOL, id);
        TEMPLATE_POOL_FACTORIES.put(templatePoolResourceKey, factory);
        return templatePoolResourceKey;
    }

    private static Holder.Reference<StructureTemplatePool> getEmptyPool(BootstrapContext<StructureTemplatePool> context) {
        return WayfinderTemplatePools.getPool(context, (ResourceKey<StructureTemplatePool>)Pools.EMPTY);
    }

    private static Holder.Reference<StructureTemplatePool> getPool(BootstrapContext<StructureTemplatePool> context, ResourceKey<StructureTemplatePool> poolResourceKey) {
        return context.lookup(Registries.TEMPLATE_POOL).getOrThrow(poolResourceKey);
    }

    private static Holder.Reference<StructureProcessorList> getProcessor(BootstrapContext<StructureTemplatePool> context, ResourceKey<StructureProcessorList> processorList) {
        return context.lookup(Registries.PROCESSOR_LIST).getOrThrow(processorList);
    }

    public static void templatePools() {
        Wayfinder.LOGGER.info("Registering Wayfinder Template Pools");
    }

    @FunctionalInterface
    public static interface TemplatePoolFactory {
        public StructureTemplatePool generate(BootstrapContext<StructureTemplatePool> var1);
    }
}

