/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.wayfinder.world.level.levelgen.structure.processor;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.potionstudios.wayfinder.Wayfinder;

public class WayfinderStructureProcessorLists {
    public static final Map<ResourceKey<StructureProcessorList>, StructureProcessorListFactory> STRUCTURE_PROCESSOR_LIST_FACTORIES = new Reference2ObjectOpenHashMap();
    public static final ResourceKey<StructureProcessorList> DESERT_SHRINE = WayfinderStructureProcessorLists.register("desert_shrine", structureProcessorListHolderGetter -> new StructureProcessorList((List)ImmutableList.of((Object)WayfinderStructureProcessorLists.createRuleProcessor(WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.SANDSTONE, 0.5f, Blocks.SAND), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.SANDSTONE, 0.25f, Blocks.SUSPICIOUS_SAND), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.CANDLE, 0.2f, (BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(2))), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.CANDLE, 0.2f, (BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(3))), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.CANDLE, 0.2f, (BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(4))), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.CANDLE, 0.2f, (BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true))), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.CANDLE, 0.2f, (BlockState)((BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(2))).setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true))), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.CANDLE, 0.2f, (BlockState)((BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(3))).setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true))), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.CANDLE, 0.2f, (BlockState)((BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(4))).setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true)))))));
    public static final ResourceKey<StructureProcessorList> SNOWY_SHRINE = WayfinderStructureProcessorLists.register("snowy_shrine", structureProcessorListHolderGetter -> new StructureProcessorList((List)ImmutableList.of((Object)WayfinderStructureProcessorLists.createRuleProcessor(WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.SNOW_BLOCK, 0.15f, Blocks.PACKED_ICE), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.SNOW_BLOCK, 0.15f, Blocks.BLUE_ICE), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.CANDLE, 0.2f, (BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(2))), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.CANDLE, 0.2f, (BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(3))), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.CANDLE, 0.2f, (BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(4))), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.CANDLE, 0.2f, (BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true))), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.CANDLE, 0.2f, (BlockState)((BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(2))).setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true))), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.CANDLE, 0.2f, (BlockState)((BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(3))).setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true))), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.CANDLE, 0.2f, (BlockState)((BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(4))).setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true)))))));
    public static final ResourceKey<StructureProcessorList> TAIGA_SHRINE = WayfinderStructureProcessorLists.register("taiga_shrine", structureProcessorListHolderGetter -> new StructureProcessorList((List)ImmutableList.of((Object)WayfinderStructureProcessorLists.createRuleProcessor(WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.PODZOL, 0.15f, Blocks.MOSS_BLOCK), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.PODZOL, 0.15f, Blocks.GRASS_BLOCK), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.MOSSY_COBBLESTONE, 0.1f, Blocks.CRACKED_STONE_BRICKS), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.MOSSY_COBBLESTONE, 0.3f, Blocks.MOSSY_STONE_BRICKS), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.GRASS_BLOCK, 0.15f, Blocks.MOSS_BLOCK), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.CANDLE, 0.2f, (BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(2))), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.CANDLE, 0.2f, (BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(3))), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.CANDLE, 0.2f, (BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(4))), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.CANDLE, 0.2f, (BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true))), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.CANDLE, 0.2f, (BlockState)((BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(2))).setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true))), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.CANDLE, 0.2f, (BlockState)((BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(3))).setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true))), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.CANDLE, 0.2f, (BlockState)((BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(4))).setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true)))))));
    public static final ResourceKey<StructureProcessorList> PLAINS_SHRINE = WayfinderStructureProcessorLists.register("plains_shrine", structureProcessorListHolderGetter -> new StructureProcessorList((List)ImmutableList.of((Object)WayfinderStructureProcessorLists.createRuleProcessor(WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.MOSSY_COBBLESTONE, 0.1f, Blocks.CRACKED_STONE_BRICKS), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.MOSSY_COBBLESTONE, 0.3f, Blocks.MOSSY_STONE_BRICKS), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.CANDLE, 0.2f, (BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(2))), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.CANDLE, 0.2f, (BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(3))), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.CANDLE, 0.2f, (BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(4))), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.CANDLE, 0.2f, (BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true))), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.CANDLE, 0.2f, (BlockState)((BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(2))).setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true))), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.CANDLE, 0.2f, (BlockState)((BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(3))).setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true))), WayfinderStructureProcessorLists.createAlwaysTrueRandomBlockMatchTest(Blocks.CANDLE, 0.2f, (BlockState)((BlockState)Blocks.CANDLE.defaultBlockState().setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(4))).setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true)))))));

    private static ProcessorRule createAlwaysTrueRandomBlockMatchTest(Block start, float chance, Block newBlock) {
        return WayfinderStructureProcessorLists.createProcessorRule(WayfinderStructureProcessorLists.createRandomBlockMatchTest(start, chance), AlwaysTrueTest.INSTANCE, newBlock.defaultBlockState());
    }

    private static ProcessorRule createAlwaysTrueRandomBlockMatchTest(Block start, float chance, BlockState newBlock) {
        return WayfinderStructureProcessorLists.createProcessorRule(WayfinderStructureProcessorLists.createRandomBlockMatchTest(start, chance), AlwaysTrueTest.INSTANCE, newBlock);
    }

    private static RandomBlockMatchTest createRandomBlockMatchTest(Block block, float chance) {
        return new RandomBlockMatchTest(block, chance);
    }

    private static ProcessorRule createProcessorRule(RandomBlockMatchTest test, AlwaysTrueTest alwaysTrueTest, BlockState blockState) {
        return new ProcessorRule((RuleTest)test, (RuleTest)alwaysTrueTest, blockState);
    }

    private static RuleProcessor createRuleProcessor(ProcessorRule ... rules) {
        return new RuleProcessor((List)ImmutableList.copyOf((Object[])rules));
    }

    private static ResourceKey<StructureProcessorList> register(String id, StructureProcessorListFactory factory) {
        ResourceKey structureProcessorListResourceKey = Wayfinder.key(Registries.PROCESSOR_LIST, id);
        STRUCTURE_PROCESSOR_LIST_FACTORIES.put(structureProcessorListResourceKey, factory);
        return structureProcessorListResourceKey;
    }

    @FunctionalInterface
    public static interface StructureProcessorListFactory {
        public StructureProcessorList generate(HolderGetter<StructureProcessorList> var1);
    }
}

