/*
 * Decompiled with CFR 0.152.
 */
package com.mysticblazeyt.blazechat;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;

public class PlayerWhitelist {
    private static final Gson GSON = new Gson();
    private static final File FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "blazechat_whitelist.json");
    private static final Set<String> WHITELISTED_NAMES = new HashSet<String>();

    public static void addPlayer(String name) {
        WHITELISTED_NAMES.add(name.toLowerCase());
        PlayerWhitelist.save();
    }

    public static boolean removePlayer(String name) {
        boolean removed = WHITELISTED_NAMES.remove(name.toLowerCase());
        if (removed) {
            PlayerWhitelist.save();
        }
        return removed;
    }

    public static boolean isWhitelisted(String name) {
        return WHITELISTED_NAMES.contains(name.toLowerCase());
    }

    public static Set<String> getWhitelistedNames() {
        return WHITELISTED_NAMES;
    }

    private static void save() {
        try (FileWriter writer = new FileWriter(FILE);){
            GSON.toJson(WHITELISTED_NAMES, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void load() {
        if (!FILE.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(FILE);){
            Type setType = new TypeToken<Set<String>>(){}.getType();
            Set loaded = (Set)GSON.fromJson((Reader)reader, setType);
            if (loaded != null) {
                WHITELISTED_NAMES.addAll(loaded);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        PlayerWhitelist.load();
    }
}

