/*
 * Decompiled with CFR 0.152.
 */
package com.mysticblazeyt.blazechat.client;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mysticblazeyt.blazechat.PlayerWhitelist;
import com.mysticblazeyt.blazechat.client.ChatFilter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class BlazechatCommands {
    private static final SuggestionProvider<FabricClientCommandSource> SUGGEST_ONLINE_PLAYERS = (context, builder) -> {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.method_1562() == null) {
            return builder.buildFuture();
        }
        String input = builder.getRemaining().toLowerCase();
        client.method_1562().method_2880().forEach(entry -> {
            String name = entry.method_2966().getName();
            if (name.toLowerCase().startsWith(input)) {
                builder.suggest(name);
            }
        });
        return builder.buildFuture();
    };
    private static final SuggestionProvider<FabricClientCommandSource> SUGGEST_WHITELISTED_PLAYERS = (context, builder) -> {
        String input = builder.getRemaining().toLowerCase();
        PlayerWhitelist.getWhitelistedNames().forEach(name -> {
            if (name.toLowerCase().startsWith(input)) {
                builder.suggest(name);
            }
        });
        return builder.buildFuture();
    };

    public static void register() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"blazechat").then(ClientCommandManager.literal((String)"addplayer").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_ONLINE_PLAYERS).executes(context -> BlazechatCommands.addPlayer((CommandContext<FabricClientCommandSource>)context, StringArgumentType.getString((CommandContext)context, (String)"name")))))).then(ClientCommandManager.literal((String)"removeplayer").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_WHITELISTED_PLAYERS).executes(context -> BlazechatCommands.removePlayer((CommandContext<FabricClientCommandSource>)context, StringArgumentType.getString((CommandContext)context, (String)"name")))))).then(ClientCommandManager.literal((String)"listplayers").executes(BlazechatCommands::listPlayers))).then(ClientCommandManager.literal((String)"enable").executes(context -> {
            ChatFilter.filteringEnabled = true;
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"BlazeChat filtering enabled.").method_27692(class_124.field_1060));
            return 1;
        }))).then(ClientCommandManager.literal((String)"disable").executes(context -> {
            ChatFilter.filteringEnabled = false;
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"BlazeChat filtering disabled.").method_27692(class_124.field_1061));
            return 1;
        }))));
    }

    private static int addPlayer(CommandContext<FabricClientCommandSource> context, String name) {
        PlayerWhitelist.addPlayer(name);
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Added '").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)name).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"' to whitelist.").method_27692(class_124.field_1060)));
        return 1;
    }

    private static int removePlayer(CommandContext<FabricClientCommandSource> context, String name) {
        if (PlayerWhitelist.removePlayer(name)) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Removed '").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)name).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"' from whitelist.").method_27692(class_124.field_1054)));
        } else {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"'").method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43470((String)name).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"' not found in whitelist.").method_27692(class_124.field_1061)));
        }
        return 1;
    }

    private static int listPlayers(CommandContext<FabricClientCommandSource> context) {
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Blazechat Whitelist:").method_27692(class_124.field_1065));
        PlayerWhitelist.getWhitelistedNames().forEach(name -> ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"- ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)name).method_27692(class_124.field_1068))));
        return 1;
    }
}

