/*
 * Decompiled with CFR 0.152.
 */
package com.mysticblazeyt.blazechat.client;

import com.mysticblazeyt.blazechat.PlayerWhitelist;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;

@Environment(value=EnvType.CLIENT)
public class ChatFilter {
    public static boolean filteringEnabled = false;
    private static final String BLAZECHAT_KEYWORD = "blazechat";

    public static void init() {
        ClientReceiveMessageEvents.ALLOW_CHAT.register((message, signedMessage, senderProfile, params, timestamp) -> {
            if (!filteringEnabled) {
                return true;
            }
            String raw = message.getString().toLowerCase();
            if (raw.contains(BLAZECHAT_KEYWORD)) {
                return true;
            }
            for (String whitelisted : PlayerWhitelist.getWhitelistedNames()) {
                if (!raw.contains(whitelisted.toLowerCase())) continue;
                return true;
            }
            System.out.println("[BlazeChat] Blocked chat: " + message.getString());
            return false;
        });
        ClientReceiveMessageEvents.ALLOW_GAME.register((message, overlay) -> {
            if (!filteringEnabled) {
                return true;
            }
            String raw = message.getString().toLowerCase();
            if (raw.contains(BLAZECHAT_KEYWORD)) {
                return true;
            }
            for (String whitelisted : PlayerWhitelist.getWhitelistedNames()) {
                if (!raw.contains(whitelisted.toLowerCase())) continue;
                return true;
            }
            System.out.println("[BlazeChat] Blocked game message: " + message.getString());
            return false;
        });
    }
}

