package archives.tater.bundlebackportish;

import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_5537;

/**
 * Based on <a href="https://github.com/zacharybarbanell/bundle-scroll">Bundle Tweaks</a> by
 * <a href="https://github.com/zacharybarbanell">zacharybarnabell</a> (MIT License)
 */
public class BundleBackportishNetworking {
    public static void register() {
        PayloadTypeRegistry.playC2S().register(BundleScrollPayload.ID, BundleScrollPayload.CODEC);

        ServerPlayNetworking.registerGlobalReceiver(BundleScrollPayload.ID, (payload, context) -> {

            context.server().execute( () -> {
                var player = context.player();
                var i = payload.i();

                player.method_14234();
                class_1703 screenHandler = player.field_7512;

                if (screenHandler.field_7763 != payload.syncId()) {
                    return;
                }
                if (player.method_7325()) {
                    screenHandler.method_34252();
                    return;
                }
                if (!screenHandler.method_7597(player)) {
                    BundleBackportish.LOGGER.debug("Player {} interacted with invalid menu {}", player, screenHandler);
                    return;
                }
                if (!screenHandler.method_40442(i)) {
                    BundleBackportish.LOGGER.debug("Player {} clicked invalid slot index: {}, available slots: {}", player.method_5477(), i, screenHandler.field_7761.size());
                    return;
                }
                boolean flag = payload.revision() == player.field_7512.method_37421();
                screenHandler.method_34256();
                class_1735 slot = screenHandler.method_7611(i);
                class_1799 stack = slot.method_7677();
                if (stack.method_7909() instanceof class_5537) {
                    BundleSelection.add(stack, payload.amt());
                }
                screenHandler.method_34257();
                if (flag) {
                    screenHandler.method_37420();
                } else {
                    screenHandler.method_7623();
                }
            });
        });
    }
}
