package archives.tater.bundlebackportish;

import archives.tater.bundlebackportish.mixin.BundleContentsComponentBuilderAccessor;
import archives.tater.bundlebackportish.mixin.BundleContentsComponentInvoker;
import net.minecraft.class_1799;
import net.minecraft.class_9276;
import net.minecraft.class_9334;
import org.apache.commons.lang3.math.Fraction;

import static java.lang.Math.*;

public class BundleSelection {
    private static int getContentsSize(class_1799 itemStack) {
        return itemStack.method_57825(class_9334.field_49650, class_9276.field_49289).method_57426();
    }

    private static int clampToContents(class_1799 itemStack, int index) {
        return clamp(index, 0, max(getContentsSize(itemStack) - 1, 0));
    }

    public static int get(class_1799 itemStack) {
        return clampToContents(itemStack, itemStack.method_57825(BundleBackportishItems.BUNDLE_SELECTION, 0));
    }

    public static void set(class_1799 itemStack, int selected) {
        itemStack.method_57379(BundleBackportishItems.BUNDLE_SELECTION, clampToContents(itemStack, selected));
    }

    public static void clear(class_1799 itemStack) {
        itemStack.method_57381(BundleBackportishItems.BUNDLE_SELECTION);
    }

    public static void add(class_1799 itemStack, int amount) {
        set(itemStack, floorMod(get(itemStack) + amount, max(getContentsSize(itemStack), 1)));
    }

    public static class_1799 remove(class_9276.class_9277 contents, int index) {
        var stacks = ((BundleContentsComponentBuilderAccessor) contents).bundlebackportish$getStacks();
        if (stacks.isEmpty())
            return null;

        var itemStack = stacks.remove(clamp(index, 0, stacks.size())).method_7972();
        ((BundleContentsComponentBuilderAccessor) contents).bundlebackportish$setOccupancy(
                contents.method_57433().subtract(
                        BundleContentsComponentInvoker.invokeGetOccupancy(itemStack).multiplyBy(
                                Fraction.getFraction(itemStack.method_7947(), 1))));
        return itemStack;
    }
}
