package archives.tater.bundlebackportish.datagen;

import archives.tater.bundlebackportish.BundleBackportish;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.minecraft.class_1792;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.data.client.*;
import java.util.Optional;

import static archives.tater.bundlebackportish.BundleBackportishItems.*;

public class ModelGenerator extends FabricModelProvider {
    public ModelGenerator(FabricDataOutput output) {
        super(output);
    }

    private static void registerBundle(class_1792 bundleItem, class_4915 itemModelGenerator) {
        var filledModelId = class_4941.method_25841(bundleItem, "_filled");

        var filledOverride = new JsonObject();
        var predicate = new JsonObject();
        predicate.addProperty(BundleBackportish.id("filled").toString(), 0.0000001);
        filledOverride.add("predicate", predicate);
        filledOverride.addProperty("model", filledModelId.toString());
        var overrides = new JsonArray();
        overrides.add(filledOverride);

        // { "predicate": { "filled": 0.0000001 }, "model": "item/bundle_filled" }
        var baseModel = class_4943.field_22938.method_48525(class_4941.method_25840(bundleItem), class_4944.method_25871(bundleItem), itemModelGenerator.field_22844, (id, textures) -> {
            var json = class_4943.field_22938.method_48524(id, textures);
            json.add("overrides", overrides);
            return json;
        });
        new class_4942(Optional.of(baseModel), Optional.empty(), class_4945.field_23006).method_25852(filledModelId, class_4944.method_25895(class_4944.method_25863(bundleItem, "_filled")), itemModelGenerator.field_22844);
    }

    @Override
    public void generateBlockStateModels(class_4910 blockStateModelGenerator) {

    }

    @Override
    public void generateItemModels(class_4915 itemModelGenerator) {
        registerBundle(WHITE_BUNDLE, itemModelGenerator);
        registerBundle(ORANGE_BUNDLE, itemModelGenerator);
        registerBundle(MAGENTA_BUNDLE, itemModelGenerator);
        registerBundle(LIGHT_BLUE_BUNDLE, itemModelGenerator);
        registerBundle(YELLOW_BUNDLE, itemModelGenerator);
        registerBundle(LIME_BUNDLE, itemModelGenerator);
        registerBundle(PINK_BUNDLE, itemModelGenerator);
        registerBundle(GRAY_BUNDLE, itemModelGenerator);
        registerBundle(LIGHT_GRAY_BUNDLE, itemModelGenerator);
        registerBundle(CYAN_BUNDLE, itemModelGenerator);
        registerBundle(PURPLE_BUNDLE, itemModelGenerator);
        registerBundle(BLUE_BUNDLE, itemModelGenerator);
        registerBundle(BROWN_BUNDLE, itemModelGenerator);
        registerBundle(GREEN_BUNDLE, itemModelGenerator);
        registerBundle(RED_BUNDLE, itemModelGenerator);
        registerBundle(BLACK_BUNDLE, itemModelGenerator);
    }
}
