package archives.tater.bundlebackportish.mixin;

import archives.tater.bundlebackportish.BundleSelection;
import archives.tater.bundlebackportish.SelectionBundleTooltipData;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_5537;
import net.minecraft.class_5632;
import net.minecraft.class_9276;

@Mixin(class_5537.class)
public abstract class BundleItemMixin {
    @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
    @ModifyReturnValue(
            method = "getTooltipData",
            at = @At("RETURN")
    )
    private Optional<class_5632> setDataSelected(Optional<class_5632> original, @Local(argsOnly = true) class_1799 itemStack) {
        return original.map(tooltipData ->
                tooltipData instanceof net.minecraft.class_5631 bundleData
                        ? new SelectionBundleTooltipData(bundleData.comp_2377(), BundleSelection.get(itemStack))
                        : tooltipData);
    }

    @WrapOperation(
            method = "onClicked",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/component/type/BundleContentsComponent$Builder;removeFirst()Lnet/minecraft/item/ItemStack;")
    )
    private class_1799 removeSelected(class_9276.class_9277 instance, Operation<class_1799> original, @Local(argsOnly = true, ordinal = 0) class_1799 stack) {
        var selected = BundleSelection.get(stack);
        if (selected == 0) return original.call(instance);
        return BundleSelection.remove(instance, selected);
    }

    @ModifyExpressionValue(
            method = "onClicked",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/component/type/BundleContentsComponent$Builder;build()Lnet/minecraft/component/type/BundleContentsComponent;")
    )
    private class_9276 fixAfterRemove(class_9276 original, @Local(argsOnly = true, ordinal = 0) class_1799 stack) {
        if (original.method_57429())
            BundleSelection.clear(stack);
        else if (BundleSelection.get(stack) >= original.method_57426())
            BundleSelection.set(stack, original.method_57426() - 1);
        return original;
    }

    @Inject(
            method = "dropAllBundledItems",
            at = @At(value = "RETURN", ordinal = 0)
    )
    private static void fixAfterDropAll(class_1799 stack, class_1657 player, CallbackInfoReturnable<Boolean> cir) {
        BundleSelection.clear(stack);
    }
}
