package archives.tater.bundlebackportish;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleBackportish implements ModInitializer {
	public static final String MOD_ID = "bundle-backportish";

	// This logger is used to write text to the console and the log file.
	// It is considered best practice to use your mod id as the logger's name.
	// That way, it's clear which mod wrote info, warnings, and errors.
	public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

	public static final class_1865<BundleColoringRecipe> COLORING_RECIPE = class_2378.method_10230(
			class_7923.field_41189,
			new class_2960(MOD_ID, "crafting_special_bundlecoloring"),
			new class_1866<>(BundleColoringRecipe::new)
	);

	@Override
	public void onInitialize() {
		// This code runs as soon as Minecraft is in a mod-load-ready state.
		// However, some things (like resources) may still be uninitialized.
		// Proceed with mild caution.
		BundleBackportishItems.register();

		BundleBackportishNetworking.register();

        //noinspection OptionalGetWithoutIsPresent
        ResourceManagerHelper.registerBuiltinResourcePack(
				new class_2960(MOD_ID, "rabbithide"),
				FabricLoader.getInstance().getModContainer(MOD_ID).get(),
				class_2561.method_30163("Rabbit Hide Bundle"),
				ResourcePackActivationType.NORMAL
		);
	}
}
