package archives.tater.bundlebackportish;

import archives.tater.bundlebackportish.mixin.client.HandledScreenInvoker;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_465;
import net.minecraft.class_5537;

/**
 * Based on <a href="https://github.com/zacharybarbanell/bundle-scroll">Bundle Tweaks</a> by
 * <a href="https://github.com/zacharybarbanell">zacharybarnabell</a> (MIT License)
 */
public class BundleBackportishClientNetworking {
    private static double accScroll = 0;

    public static void register() {
        ScreenEvents.BEFORE_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (screen instanceof class_465<?> handledScreen) {
                ScreenMouseEvents.afterMouseScroll(screen).register((_screen, x, y, horiz, vert) ->
                        BundleBackportishClientNetworking.onMouseScrolled(handledScreen, x, y, vert));
            }
        });
    }

    private static boolean onMouseScrolled(class_465<?> screen, double x, double y, double scroll) {
        class_1735 slot = ((HandledScreenInvoker) screen).invokeGetSlotAt(x, y);
        if (slot == null) {
            return true;
        }
        class_1799 stack = slot.method_7677();
        if (!(stack.method_7909() instanceof class_5537)) {
            return true;
        }
        if (accScroll * scroll < 0) {
            accScroll = 0;
        }
        accScroll += scroll;
        int amt = (int) accScroll;
        accScroll -= amt;
        if (amt == 0) {
            return true;
        }

        BundleSelection.add(stack, -amt);

        class_2540 buf = PacketByteBufs.create();

        buf.writeInt(screen.method_17577().field_7763);
        buf.writeInt(screen.method_17577().method_37421());
        buf.writeInt(slot.field_7874);
        buf.writeInt(-amt);

        ClientPlayNetworking.send(BundleBackportishNetworking.SCROLL_PACKET_ID, buf);

        return false;
    }
}
