package archives.tater.bundlebackportish;

import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_3956;
import net.minecraft.class_5537;
import net.minecraft.class_7923;

public class BundleBackportishEmiPlugin implements EmiPlugin {
    private static final List<class_1792> BUNDLES = class_7923.field_41178.method_10220().filter(item -> item instanceof class_5537).toList();

    @Override
    public void register(EmiRegistry emiRegistry) {
        if (emiRegistry.getRecipeManager().method_30027(class_3956.field_17545).stream()
                .anyMatch(craftingRecipe -> craftingRecipe instanceof BundleColoringRecipe)) {
            BundleColoringRecipe.COLORS.forEach((dye, bundle) -> {
                emiRegistry.addRecipe(new EmiCraftingRecipe(
                        List.of(EmiIngredient.of(BUNDLES.stream()
                                .filter(item -> item != bundle)
                                .map(EmiStack::of)
                                .toList()), EmiStack.of(dye)),
                        EmiStack.of(bundle),
                        class_7923.field_41178.method_10221(bundle),
                        true));
            });
        }
    }
}
