package archives.tater.bundlebackportish;

import org.jetbrains.annotations.Nullable;

import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_5537;
import net.minecraft.class_7710;
import net.minecraft.class_8566;

import static archives.tater.bundlebackportish.BundleBackportishItems.*;
import static java.util.Map.entry;

public class BundleColoringRecipe extends class_1852 {

    public BundleColoringRecipe(class_2960 identifier, class_7710 craftingRecipeCategory) {
        super(identifier, craftingRecipeCategory);
    }

    private <T> boolean containsExactly(Iterable<T> collection, Predicate<T> condition, int matchCount) {
        var count = 0;
        for (var item : collection) {
            if (condition.test(item)) {
                count++;
                if (count == matchCount) return true;
            }
        }
        return false;
    }

    private <T> @Nullable T find(Iterable<T> collection, Predicate<T> condition) {
        for (var item : collection) {
            if (condition.test(item)) {
                return item;
            }
        }
        return null;
    }

    public boolean matches(class_8566 recipeInputInventory, class_1937 world) {
        var items = recipeInputInventory.method_51305().stream().map(class_1799::method_7909).toList();
        return containsExactly(items, item -> item instanceof class_5537, 1) &&
                containsExactly(items, COLORS::containsKey, 1);
    }

    public class_1799 craft(class_8566 recipeInputInventory, class_5455 dynamicRegistryManager) {
        var bundle = find(recipeInputInventory.method_51305(), stack -> stack.method_7909() instanceof class_5537);
        var dye = find(recipeInputInventory.method_51305(), stack -> COLORS.containsKey(stack.method_7909()));
        if (bundle == null || dye == null) return class_1799.field_8037; // This shouldn't happen but just in case
        var outputBundle = COLORS.get(dye.method_7909());
        if (bundle.method_31574(outputBundle)) return class_1799.field_8037;
        var resultStack = new class_1799(outputBundle);
        resultStack.method_7980(bundle.method_7969());
        return resultStack;
    }

    @Override
    public boolean method_8113(int width, int height) {
        return width * height >= 2;
    }

    @Override
    public class_1865<?> method_8119() {
        return BundleBackportish.COLORING_RECIPE;
    }

    public static final Map<class_1792, class_1792> COLORS = Map.ofEntries(
            entry(class_1802.field_8446, WHITE_BUNDLE),
            entry(class_1802.field_8492, ORANGE_BUNDLE),
            entry(class_1802.field_8669, MAGENTA_BUNDLE),
            entry(class_1802.field_8273, LIGHT_BLUE_BUNDLE),
            entry(class_1802.field_8192, YELLOW_BUNDLE),
            entry(class_1802.field_8131, LIME_BUNDLE),
            entry(class_1802.field_8330, PINK_BUNDLE),
            entry(class_1802.field_8298, GRAY_BUNDLE),
            entry(class_1802.field_8851, LIGHT_GRAY_BUNDLE),
            entry(class_1802.field_8632, CYAN_BUNDLE),
            entry(class_1802.field_8296, PURPLE_BUNDLE),
            entry(class_1802.field_8345, BLUE_BUNDLE),
            entry(class_1802.field_8099, BROWN_BUNDLE),
            entry(class_1802.field_8408, GREEN_BUNDLE),
            entry(class_1802.field_8264, RED_BUNDLE),
            entry(class_1802.field_8226, BLACK_BUNDLE)
    );

}
