package archives.tater.bundlebackportish;

import static java.lang.Math.floorMod;
import static java.lang.Math.max;

import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class BundleSelection {
    public static final String SELECTED_NBT = "Selected";

    public static int get(class_1799 itemStack) {
        class_2487 nbtCompound = itemStack.method_7969();
        if (nbtCompound == null) return 0;
        return nbtCompound.method_10550(SELECTED_NBT);
    }

    public static void set(class_1799 itemStack, int selected) {
        itemStack.method_7948().method_10569(BundleSelection.SELECTED_NBT, selected);
    }

    public static void clear(class_1799 itemStack) {
        itemStack.method_7983(BundleSelection.SELECTED_NBT);
    }

    public static void add(class_1799 itemStack, int amount) {
        var nbt = itemStack.method_7969();
        var itemCount = nbt != null ? max(nbt.method_10554("Items", class_2520.field_33260).size(), 1) : 1;
        set(itemStack, floorMod(get(itemStack) + amount, itemCount));
    }
}
