package archives.tater.bundlebackportish.mixin;

import archives.tater.bundlebackportish.BundleSelection;
import archives.tater.bundlebackportish.SelectionBundleTooltipData;
import com.llamalad7.mixinextras.sugar.Local;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.*;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2520;
import net.minecraft.class_5537;
import net.minecraft.class_5631;

import static java.lang.Math.max;
import static java.lang.Math.min;

@Mixin(class_5537.class)
public abstract class BundleItemMixin {
    @Unique
    private static int bundleScroll$itemCount(class_1799 itemStack) {
        var nbt = itemStack.method_7969();
        if (nbt == null) return 0;
        return nbt.method_10554("Items", class_2520.field_33260).size();
    }

    @Redirect(
            method = "getTooltipData",
            at = @At(value = "NEW", target = "(Lnet/minecraft/util/collection/DefaultedList;I)Lnet/minecraft/client/item/BundleTooltipData;")
    )
    private class_5631 setDataSelected(class_2371<class_1799> inventory, int bundleOccupancy, @Local(argsOnly = true) class_1799 itemStack) {
        return new SelectionBundleTooltipData(inventory, bundleOccupancy, BundleSelection.get(itemStack));
    }

    @ModifyConstant(
            method = "removeFirstStack",
            constant = @Constant(intValue = 0)
    )
    private static int removeSelected(int constant, @Local(argsOnly = true) class_1799 itemStack) {
        return max(min(BundleSelection.get(itemStack), bundleScroll$itemCount(itemStack) - 1), 0);
    }

    @ModifyArg(
            method = "addToBundle",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/nbt/NbtList;add(ILnet/minecraft/nbt/NbtElement;)V"),
            index = 0
    )
    private static int addAtSelected(int i, @Local(argsOnly = true, ordinal = 0) class_1799 itemStack) {
        return max(min(BundleSelection.get(itemStack), bundleScroll$itemCount(itemStack) - 1), 0);
    }

    @Inject(
            method = "removeFirstStack",
            at = @At("TAIL")
    )
    private static void fixAfterRemove(class_1799 itemStack, CallbackInfoReturnable<Optional<class_1799>> cir) {
        var items = bundleScroll$itemCount(itemStack);
        if (items == 0)
            BundleSelection.clear(itemStack);
        else if (BundleSelection.get(itemStack) >= items)
            BundleSelection.set(itemStack, items - 1);
    }

    @Inject(
            method = "dropAllBundledItems",
            at = @At("TAIL")
    )
    private static void fixAfterDropAll(class_1799 stack, class_1657 player, CallbackInfoReturnable<Boolean> cir) {
        BundleSelection.clear(stack);
    }

    @Redirect(
            method = "canMergeStack",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;isOf(Lnet/minecraft/item/Item;)Z")
    )
    private static boolean checkAnyBundleForMerge(class_1799 instance, class_1792 item) {
        return instance.method_7909() instanceof class_5537;
    }

    @Redirect(
            method = "getItemOccupancy",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;isOf(Lnet/minecraft/item/Item;)Z", ordinal = 0)
    )
    private static boolean checkAnyBundleForOccupancy(class_1799 instance, class_1792 item) {
        return instance.method_7909() instanceof class_5537;
    }
}
