/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.electricity.block;

import com.dooji.electricity.block.ElectricCabinBlock;
import com.dooji.electricity.client.TrackedBlockEntities;
import com.dooji.electricity.client.render.obj.ObjBoundingBoxRegistry;
import com.dooji.electricity.client.render.obj.ObjModel;
import com.dooji.electricity.client.wire.InsulatorLookup;
import com.dooji.electricity.client.wire.WireManagerClient;
import com.dooji.electricity.main.Electricity;
import com.dooji.electricity.wire.InsulatorIdRegistry;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import org.joml.Vector3f;

public class ElectricCabinBlockEntity
extends BlockEntity {
    private static final String[] INSULATOR_PARTS = new String[]{"insulator_input_Material.065", "insulatoroutput_Material.044"};
    private static final Vec3[] DEFAULT_INSULATOR_OFFSETS = new Vec3[]{new Vec3(0.0, 0.9, -0.35), new Vec3(0.0, 0.9, 0.35)};
    private Vec3[] wirePositions = new Vec3[2];
    private int[] insulatorIds = new int[2];
    private double currentPower = 0.0;

    public ElectricCabinBlockEntity(BlockPos pos, BlockState state) {
        super(ElectricCabinBlockEntity.getBlockEntityType(), pos, state);
        this.generateInsulatorIds();
        this.updateWirePositions();
    }

    private static BlockEntityType<ElectricCabinBlockEntity> getBlockEntityType() {
        if (Electricity.ELECTRIC_CABIN_BLOCK_ENTITY != null) {
            return (BlockEntityType)Electricity.ELECTRIC_CABIN_BLOCK_ENTITY.get();
        }
        return null;
    }

    private void generateInsulatorIds() {
        for (int i = 0; i < this.insulatorIds.length; ++i) {
            if (this.insulatorIds[i] != 0) continue;
            this.insulatorIds[i] = InsulatorIdRegistry.claimId();
        }
    }

    public static void removeInsulatorIds(int[] ids) {
        InsulatorIdRegistry.releaseIds(ids);
    }

    public Vec3 getWirePosition(int index) {
        if (index < 0 || index >= this.wirePositions.length) {
            return null;
        }
        return this.wirePositions[index];
    }

    public void setWirePosition(int index, Vec3 position) {
        if (index >= 0 && index < this.wirePositions.length) {
            this.wirePositions[index] = position;
            this.m_6596_();
        }
    }

    public int getInsulatorId(int index) {
        if (index < 0 || index >= this.insulatorIds.length) {
            return -1;
        }
        return this.insulatorIds[index];
    }

    public int[] getInsulatorIds() {
        return (int[])this.insulatorIds.clone();
    }

    public double getCurrentPower() {
        return this.currentPower;
    }

    public void setCurrentPower(double power) {
        this.currentPower = power;
    }

    public Vec3 calculateOrientedInsulatorCenter(int index) {
        Vec3 localCenter;
        if (index < 0 || index >= 2) {
            return null;
        }
        String groupName = INSULATOR_PARTS[index];
        ObjModel.BoundingBox boundingBox = ObjBoundingBoxRegistry.getBoundingBox((Block)Electricity.ELECTRIC_CABIN_BLOCK.get(), groupName);
        if (boundingBox != null) {
            Vector3f center = boundingBox.center;
            localCenter = new Vec3((double)center.x, (double)center.y, (double)center.z);
        } else if (index < DEFAULT_INSULATOR_OFFSETS.length) {
            localCenter = DEFAULT_INSULATOR_OFFSETS[index];
        } else {
            return null;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)ElectricCabinBlock.FACING);
        Vec3 rotatedCenter = this.rotateVector(localCenter, facing);
        Vec3 worldOffset = Vec3.m_82528_((Vec3i)this.m_58899_()).m_82520_(0.5, 0.0, 0.5);
        return worldOffset.m_82549_(rotatedCenter);
    }

    private Vec3 rotateVector(Vec3 vector, Direction facing) {
        float facingRotation;
        switch (facing) {
            case EAST: {
                float f = 0.0f;
                break;
            }
            case SOUTH: {
                float f = 270.0f;
                break;
            }
            case WEST: {
                float f = 180.0f;
                break;
            }
            default: {
                float f = facingRotation = 90.0f;
            }
        }
        if (facingRotation == 0.0f) {
            return vector;
        }
        float cosYaw = (float)Math.cos(Math.toRadians(facingRotation));
        float sinYaw = (float)Math.sin(Math.toRadians(facingRotation));
        float x = (float)(vector.f_82479_ * (double)cosYaw + vector.f_82481_ * (double)sinYaw);
        float z = (float)(-vector.f_82479_ * (double)sinYaw + vector.f_82481_ * (double)cosYaw);
        return new Vec3((double)x, vector.f_82480_, (double)z);
    }

    public void tick() {
        this.updateWirePositions();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            InsulatorLookup.register(this);
            WireManagerClient.invalidateInsulatorCache(this.getInsulatorIds());
        });
    }

    private void updateWirePositions() {
        for (int i = 0; i < this.wirePositions.length; ++i) {
            Vec3 calculatedPos = this.calculateOrientedInsulatorCenter(i);
            if (calculatedPos == null) continue;
            this.wirePositions[i] = calculatedPos;
        }
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        int i;
        super.m_142466_(tag);
        if (tag.m_128425_("wirePositions", 9)) {
            ListTag wirePositionsList = tag.m_128437_("wirePositions", 10);
            for (i = 0; i < Math.min(wirePositionsList.size(), this.wirePositions.length); ++i) {
                CompoundTag posTag = wirePositionsList.m_128728_(i);
                if (!posTag.m_128441_("x") || !posTag.m_128441_("y") || !posTag.m_128441_("z")) continue;
                this.wirePositions[i] = new Vec3(posTag.m_128459_("x"), posTag.m_128459_("y"), posTag.m_128459_("z"));
            }
        }
        if (tag.m_128425_("insulatorIds", 9)) {
            ListTag insulatorIdsList = tag.m_128437_("insulatorIds", 3);
            for (i = 0; i < Math.min(insulatorIdsList.size(), this.insulatorIds.length); ++i) {
                this.insulatorIds[i] = insulatorIdsList.m_128763_(i);
                InsulatorIdRegistry.registerExistingId(this.insulatorIds[i]);
            }
        } else {
            this.generateInsulatorIds();
        }
        if (tag.m_128441_("currentPower")) {
            this.currentPower = tag.m_128459_("currentPower");
        }
        this.updateWirePositions();
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        ListTag wirePositionsList = new ListTag();
        for (Vec3 pos : this.wirePositions) {
            if (pos != null) {
                CompoundTag posTag = new CompoundTag();
                posTag.m_128347_("x", pos.f_82479_);
                posTag.m_128347_("y", pos.f_82480_);
                posTag.m_128347_("z", pos.f_82481_);
                wirePositionsList.add((Object)posTag);
                continue;
            }
            wirePositionsList.add((Object)new CompoundTag());
        }
        tag.m_128365_("wirePositions", (Tag)wirePositionsList);
        ListTag insulatorIdsList = new ListTag();
        for (int id : this.insulatorIds) {
            insulatorIdsList.add((Object)IntTag.m_128679_((int)id));
        }
        tag.m_128365_("insulatorIds", (Tag)insulatorIdsList);
        tag.m_128347_("currentPower", this.currentPower);
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onLoad() {
        super.onLoad();
        this.updateWirePositions();
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                TrackedBlockEntities.track(this);
                InsulatorLookup.register(this);
                WireManagerClient.invalidateInsulatorCache(this.getInsulatorIds());
            });
        }
    }

    public void m_7651_() {
        super.m_7651_();
        InsulatorIdRegistry.releaseIds(this.getInsulatorIds());
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                TrackedBlockEntities.untrack(this);
                InsulatorLookup.unregister(this.getInsulatorIds());
                WireManagerClient.invalidateInsulatorCache(this.getInsulatorIds());
            });
        }
    }
}

