/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.electricity.block;

import com.dooji.electricity.block.ElectricLampBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ElectricLampBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final EnumProperty<LampState> GLOW_STATE = EnumProperty.m_61587_((String)"glow_state", LampState.class);
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public ElectricLampBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60953_(state -> ((LampState)((Object)((Object)state.m_61143_(GLOW_STATE)))).getLightLevel()).m_60918_(SoundType.f_56744_));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.FALSE)).m_61124_(GLOW_STATE, (Comparable)((Object)LampState.OFF)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT, GLOW_STATE});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ElectricLampBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : (lvl, pos, blockState, blockEntity) -> {
            if (blockEntity instanceof ElectricLampBlockEntity) {
                ElectricLampBlockEntity lamp = (ElectricLampBlockEntity)blockEntity;
                lamp.serverTick();
            }
        };
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof ElectricLampBlockEntity) {
            ElectricLampBlockEntity lamp = (ElectricLampBlockEntity)blockEntity;
            lamp.updateLampState();
        }
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
    }

    public boolean m_7899_(BlockState state) {
        return false;
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 0;
    }

    public int m_6376_(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 0;
    }

    public static enum LampState implements StringRepresentable
    {
        OFF("off", 0, false),
        DIM("dim", 5, true),
        WARM("warm", 10, true),
        BRIGHT("bright", 13, true),
        OVERDRIVE("overdrive", 15, true),
        BURNT("burnt", 0, false);

        private final String name;
        private final int lightLevel;
        private final boolean emits;

        private LampState(String name, int lightLevel, boolean emits) {
            this.name = name;
            this.lightLevel = lightLevel;
            this.emits = emits;
        }

        public int getLightLevel() {
            return this.lightLevel;
        }

        public boolean isEmitting() {
            return this.emits;
        }

        public String m_7912_() {
            return this.name;
        }

        public static LampState fromName(String name) {
            for (LampState state : LampState.values()) {
                if (!state.name.equals(name)) continue;
                return state;
            }
            return OFF;
        }
    }
}

