/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.electricity.block;

import com.dooji.electricity.api.power.ElectricityCapabilities;
import com.dooji.electricity.api.power.IElectricPowerConsumer;
import com.dooji.electricity.api.power.PowerDeliveryEvent;
import com.dooji.electricity.block.ElectricLampBlock;
import com.dooji.electricity.main.Electricity;
import com.dooji.electricity.power.PowerFieldManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class ElectricLampBlockEntity
extends BlockEntity
implements IElectricPowerConsumer {
    private static final double REQUIRED_POWER = 0.2;
    private static final double MINIMUM_POWER = 0.15;
    private static final double POWER_FILTER = 0.25;
    private static final double POWER_EPSILON = 1.0E-4;
    private static final double OVERDRIVE_MULTIPLIER = 1.25;
    private static final double REGULATED_POWER_LIMIT = 0.27;
    private static final double THERMAL_RESPONSE = 0.18;
    private static final double COOLING_RATE = 0.02;
    private static final double OVERHEAT_THRESHOLD = 1.1;
    private static final double MELT_THRESHOLD = 1.45;
    private static final double WEAR_OVERHEAT_RATE = 0.0045;
    private static final double WEAR_RECOVERY = 0.002;
    private static final double WEAR_SURGE_RATE = 0.0035;
    private boolean capabilityPowered = false;
    private boolean burnedOut = false;
    private double deliveredPower = 0.0;
    private double filteredPower = 0.0;
    private double filamentTemperature = 0.0;
    private double degradation = 0.0;
    private double pendingSurgeSeverity = 0.0;
    private int pendingSurgeTicks = 0;
    private double pendingBrownoutFactor = 1.0;
    private boolean pendingDisconnect = false;
    private ElectricLampBlock.LampState visualState = ElectricLampBlock.LampState.OFF;
    private long lastPowerTick = -1L;
    private final LazyOptional<IElectricPowerConsumer> consumerCapability = LazyOptional.of(() -> this);

    public ElectricLampBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Electricity.ELECTRIC_LAMP_BLOCK_ENTITY.get(), pos, state);
        if (state.m_61138_(ElectricLampBlock.GLOW_STATE)) {
            this.visualState = (ElectricLampBlock.LampState)((Object)state.m_61143_(ElectricLampBlock.GLOW_STATE));
        }
    }

    @Override
    public double getRequiredPower() {
        return 0.2;
    }

    @Override
    public double getMinimumOperationalPower() {
        return 0.15;
    }

    @Override
    public void onPowerSupplied(double deliveredPower, boolean meetsRequirement, PowerDeliveryEvent event) {
        if (this.burnedOut) {
            return;
        }
        this.deliveredPower = Math.max(deliveredPower, 0.0);
        boolean bl = this.capabilityPowered = this.deliveredPower > 0.0;
        if (this.f_58857_ != null) {
            this.lastPowerTick = this.f_58857_.m_46467_();
        }
        if (event != null) {
            this.pendingSurgeSeverity = Math.max(this.pendingSurgeSeverity, event.surgeSeverity());
            this.pendingSurgeTicks = Math.max(this.pendingSurgeTicks, event.surgeDuration());
            this.pendingBrownoutFactor = Math.min(this.pendingBrownoutFactor, event.brownoutFactor());
            if (event.disconnectActive()) {
                this.pendingDisconnect = true;
            }
        }
    }

    public void serverTick() {
        double rawInput;
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        boolean capPowered = this.isCapabilityPowerActive();
        if (!capPowered && this.capabilityPowered) {
            this.capabilityPowered = false;
            this.deliveredPower = 0.0;
        }
        if (this.pendingSurgeTicks > 0) {
            --this.pendingSurgeTicks;
        } else {
            this.pendingSurgeSeverity = 0.0;
        }
        if (!this.pendingDisconnect) {
            this.pendingBrownoutFactor = Math.min(this.pendingBrownoutFactor, 1.0);
        }
        double fieldPower = PowerFieldManager.getPowerAt(this.f_58858_);
        double d = this.burnedOut ? 0.0 : (rawInput = Math.max(fieldPower, capPowered ? this.deliveredPower : 0.0));
        if (this.pendingDisconnect) {
            rawInput = 0.0;
            this.pendingDisconnect = false;
        } else if (this.pendingBrownoutFactor < 1.0) {
            rawInput *= Math.max(0.0, this.pendingBrownoutFactor);
        }
        double regulatedPower = Math.min(rawInput, 0.27);
        this.filteredPower += (regulatedPower - this.filteredPower) * 0.25;
        if (this.filteredPower < 1.0E-4) {
            this.filteredPower = 0.0;
        }
        if (!this.burnedOut) {
            this.updateThermalState(regulatedPower);
        }
        ElectricLampBlock.LampState nextState = this.selectState();
        if (this.burnedOut) {
            nextState = ElectricLampBlock.LampState.BURNT;
        }
        if (nextState != this.visualState || this.getCurrentLampState() != nextState) {
            this.visualState = nextState;
            this.applyLampState(nextState);
        } else if (this.f_58857_.m_46467_() % 40L == 0L) {
            this.applyLampState(nextState);
        }
        if (this.pendingSurgeTicks == 0) {
            this.pendingSurgeSeverity = 0.0;
        }
        this.pendingBrownoutFactor = 1.0;
    }

    private boolean isCapabilityPowerActive() {
        if (!this.capabilityPowered || this.f_58857_ == null) {
            return false;
        }
        long age = this.f_58857_.m_46467_() - this.lastPowerTick;
        return age <= 2L;
    }

    private void updateThermalState(double regulatedPower) {
        double targetTemp = Math.max(0.0, regulatedPower / 0.2);
        this.filamentTemperature = targetTemp >= this.filamentTemperature ? (this.filamentTemperature += (targetTemp - this.filamentTemperature) * 0.18) : (this.filamentTemperature -= Math.min(this.filamentTemperature - targetTemp, 0.02));
        this.filamentTemperature = Math.max(0.0, this.filamentTemperature);
        if (this.filamentTemperature <= 1.1) {
            this.degradation = Math.max(0.0, this.degradation - 0.002);
            if (this.pendingSurgeSeverity > 0.0) {
                this.degradation = Math.min(1.0, this.degradation + this.pendingSurgeSeverity * 0.0035);
            }
            return;
        }
        double excess = this.filamentTemperature - 1.1;
        double severity = Mth.m_14008_((double)(excess / 0.34999999999999987), (double)0.0, (double)1.0);
        this.degradation = Math.min(1.0, this.degradation + severity * 0.0045 + this.pendingSurgeSeverity * 0.0035);
        if (this.filamentTemperature >= 1.45 || this.degradation >= 1.0) {
            this.burnedOut = true;
            this.deliveredPower = 0.0;
            this.filteredPower = 0.0;
            this.filamentTemperature = 0.0;
        }
    }

    private ElectricLampBlock.LampState selectState() {
        if (this.burnedOut || this.f_58857_ == null) {
            return ElectricLampBlock.LampState.BURNT;
        }
        double normalizedPower = this.filteredPower / 0.2;
        double ratio = Math.max(normalizedPower, this.filamentTemperature);
        if (ratio <= 0.3) {
            return ElectricLampBlock.LampState.OFF;
        }
        if (ratio < 0.65) {
            return this.shouldFlicker(ratio) ? ElectricLampBlock.LampState.OFF : ElectricLampBlock.LampState.DIM;
        }
        if (ratio < 1.0) {
            return ElectricLampBlock.LampState.WARM;
        }
        if (ratio < 1.25) {
            return ElectricLampBlock.LampState.BRIGHT;
        }
        return ElectricLampBlock.LampState.OVERDRIVE;
    }

    private boolean shouldFlicker(double ratio) {
        if (this.f_58857_ == null) {
            return false;
        }
        double instability = Mth.m_14008_((double)(0.45 - ratio * 0.4 + this.pendingSurgeSeverity * 0.3), (double)0.1, (double)0.7);
        long hash = this.f_58858_.m_121878_() * 31L + this.f_58857_.m_46467_();
        double noise = (double)(hash & 0xFFFFL) / 65535.0;
        return noise < instability;
    }

    private ElectricLampBlock.LampState getCurrentLampState() {
        BlockState state = this.m_58900_();
        if (state.m_61138_(ElectricLampBlock.GLOW_STATE)) {
            return (ElectricLampBlock.LampState)((Object)state.m_61143_(ElectricLampBlock.GLOW_STATE));
        }
        return ElectricLampBlock.LampState.OFF;
    }

    private void applyLampState(ElectricLampBlock.LampState desired) {
        if (this.f_58857_ == null) {
            return;
        }
        BlockState currentState = this.m_58900_();
        if (!(currentState.m_60734_() instanceof ElectricLampBlock)) {
            return;
        }
        boolean lit = desired.isEmitting() && !this.burnedOut;
        BlockState updated = (BlockState)((BlockState)currentState.m_61124_((Property)ElectricLampBlock.LIT, (Comparable)Boolean.valueOf(lit))).m_61124_(ElectricLampBlock.GLOW_STATE, (Comparable)((Object)desired));
        if (!updated.equals(currentState)) {
            this.f_58857_.m_7731_(this.f_58858_, updated, 3);
        }
    }

    void updateLampState() {
        this.applyLampState(this.visualState);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128347_("deliveredPower", this.deliveredPower);
        tag.m_128347_("filteredPower", this.filteredPower);
        tag.m_128347_("filamentTemperature", this.filamentTemperature);
        tag.m_128347_("degradation", this.degradation);
        tag.m_128379_("capabilityPowered", this.capabilityPowered);
        tag.m_128379_("burnedOut", this.burnedOut);
        tag.m_128356_("lastPowerTick", this.lastPowerTick);
        tag.m_128359_("glowState", this.visualState.m_7912_());
        tag.m_128347_("pendingSurgeSeverity", this.pendingSurgeSeverity);
        tag.m_128405_("pendingSurgeTicks", this.pendingSurgeTicks);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.deliveredPower = tag.m_128459_("deliveredPower");
        this.filteredPower = tag.m_128459_("filteredPower");
        this.filamentTemperature = tag.m_128459_("filamentTemperature");
        this.degradation = tag.m_128441_("degradation") ? tag.m_128459_("degradation") : 0.0;
        this.capabilityPowered = tag.m_128471_("capabilityPowered");
        this.burnedOut = tag.m_128471_("burnedOut");
        this.lastPowerTick = tag.m_128454_("lastPowerTick");
        this.visualState = tag.m_128441_("glowState") ? ElectricLampBlock.LampState.fromName(tag.m_128461_("glowState")) : ElectricLampBlock.LampState.OFF;
        this.pendingSurgeSeverity = tag.m_128441_("pendingSurgeSeverity") ? tag.m_128459_("pendingSurgeSeverity") : 0.0;
        this.pendingSurgeTicks = tag.m_128441_("pendingSurgeTicks") ? tag.m_128451_("pendingSurgeTicks") : 0;
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null) {
            this.visualState = this.getCurrentLampState();
        }
        this.updateLampState();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ElectricityCapabilities.ELECTRIC_CONSUMER) {
            return this.consumerCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.consumerCapability.invalidate();
    }
}

