/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.electricity.block;

import com.dooji.electricity.api.power.ElectricityCapabilities;
import com.dooji.electricity.api.power.IElectricPowerConsumer;
import com.dooji.electricity.api.power.PowerDeliveryEvent;
import com.dooji.electricity.block.PowerBoxBlock;
import com.dooji.electricity.client.TrackedBlockEntities;
import com.dooji.electricity.client.render.obj.ObjBoundingBoxRegistry;
import com.dooji.electricity.client.render.obj.ObjModel;
import com.dooji.electricity.client.wire.InsulatorLookup;
import com.dooji.electricity.client.wire.WireManagerClient;
import com.dooji.electricity.main.Electricity;
import com.dooji.electricity.main.ElectricityServerConfig;
import com.dooji.electricity.power.PowerFieldManager;
import com.dooji.electricity.wire.InsulatorIdRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import org.joml.Vector3f;

public class PowerBoxBlockEntity
extends BlockEntity {
    private Vec3[] wirePositions = new Vec3[1];
    private int[] insulatorIds = new int[1];
    private double currentPower = 0.0;
    private static final double POWER_THRESHOLD = 0.1;
    private static final String[] POWER_PROPERTY_NAMES = new String[]{"powered", "lit"};
    private static final Vec3 DEFAULT_INSULATOR_OFFSET = new Vec3(0.0, 0.75, -0.25);
    private PowerDeliveryEvent incomingEvent = PowerDeliveryEvent.none();
    private boolean breakerTripped = false;
    private int breakerCooldown = 0;
    private final Set<BlockPos> poweredBlocks = new HashSet<BlockPos>();
    private boolean powerFieldActive = false;

    public PowerBoxBlockEntity(BlockPos pos, BlockState state) {
        super(PowerBoxBlockEntity.getBlockEntityType(), pos, state);
        this.generateInsulatorIds();
        this.updateWirePositions();
    }

    private static BlockEntityType<PowerBoxBlockEntity> getBlockEntityType() {
        if (Electricity.POWER_BOX_BLOCK_ENTITY != null) {
            return (BlockEntityType)Electricity.POWER_BOX_BLOCK_ENTITY.get();
        }
        return null;
    }

    private void generateInsulatorIds() {
        for (int i = 0; i < this.insulatorIds.length; ++i) {
            if (this.insulatorIds[i] != 0) continue;
            this.insulatorIds[i] = InsulatorIdRegistry.claimId();
        }
    }

    public static void removeInsulatorIds(int[] ids) {
        InsulatorIdRegistry.releaseIds(ids);
    }

    public Vec3 getWirePosition(int index) {
        if (index < 0 || index >= this.wirePositions.length) {
            return null;
        }
        return this.wirePositions[index];
    }

    public void setWirePosition(int index, Vec3 position) {
        if (index >= 0 && index < this.wirePositions.length) {
            this.wirePositions[index] = position;
            this.m_6596_();
        }
    }

    public int getInsulatorId(int index) {
        if (index < 0 || index >= this.insulatorIds.length) {
            return -1;
        }
        return this.insulatorIds[index];
    }

    public int[] getInsulatorIds() {
        return (int[])this.insulatorIds.clone();
    }

    public double getCurrentPower() {
        return this.currentPower;
    }

    public void setCurrentPower(double power) {
        this.currentPower = power;
    }

    public Vec3 calculateOrientedInsulatorCenter(int index) {
        Vec3 localCenter;
        if (index < 0 || index >= 1) {
            return null;
        }
        String[] insulatorGroups = new String[]{"insulator_Material"};
        String groupName = insulatorGroups[index];
        ObjModel.BoundingBox boundingBox = ObjBoundingBoxRegistry.getBoundingBox((Block)Electricity.POWER_BOX_BLOCK.get(), groupName);
        if (boundingBox != null) {
            Vector3f center = boundingBox.center;
            localCenter = new Vec3((double)center.x, (double)center.y, (double)center.z);
        } else {
            localCenter = DEFAULT_INSULATOR_OFFSET;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)PowerBoxBlock.FACING);
        Vec3 rotatedCenter = this.rotateVector(localCenter, facing);
        Vec3 worldOffset = Vec3.m_82528_((Vec3i)this.m_58899_()).m_82520_(0.5, 0.0, 0.5);
        return worldOffset.m_82549_(rotatedCenter);
    }

    private Vec3 rotateVector(Vec3 vector, Direction facing) {
        float facingRotation;
        switch (facing) {
            case EAST: {
                float f = 0.0f;
                break;
            }
            case SOUTH: {
                float f = 270.0f;
                break;
            }
            case WEST: {
                float f = 180.0f;
                break;
            }
            default: {
                float f = facingRotation = 90.0f;
            }
        }
        if (facingRotation == 0.0f) {
            return vector;
        }
        float cosYaw = (float)Math.cos(Math.toRadians(facingRotation));
        float sinYaw = (float)Math.sin(Math.toRadians(facingRotation));
        float x = (float)(vector.f_82479_ * (double)cosYaw + vector.f_82481_ * (double)sinYaw);
        float z = (float)(-vector.f_82479_ * (double)sinYaw + vector.f_82481_ * (double)cosYaw);
        return new Vec3((double)x, vector.f_82480_, (double)z);
    }

    public void tick() {
        boolean shouldActivate;
        this.updateWirePositions();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            InsulatorLookup.register(this);
            WireManagerClient.invalidateInsulatorCache(this.getInsulatorIds());
        });
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        if (this.breakerCooldown > 0) {
            --this.breakerCooldown;
            if (this.breakerCooldown == 0) {
                this.breakerTripped = false;
            }
        }
        boolean bl = shouldActivate = this.currentPower > 0.1;
        if (shouldActivate && !this.powerFieldActive) {
            this.powerFieldActive = true;
            this.refreshPowerField();
        } else if (!shouldActivate && this.powerFieldActive) {
            this.deactivatePowerField();
        } else if (shouldActivate) {
            this.refreshPowerField();
        }
        this.incomingEvent = PowerDeliveryEvent.none();
    }

    private void updateWirePositions() {
        for (int i = 0; i < this.wirePositions.length; ++i) {
            Vec3 calculatedPos = this.calculateOrientedInsulatorCenter(i);
            if (calculatedPos == null) continue;
            this.wirePositions[i] = calculatedPos;
        }
    }

    private void refreshPowerField() {
        if (this.f_58857_ == null) {
            return;
        }
        PowerFieldManager.clearSource(this.f_58858_);
        HashSet newlyPowered = new HashSet();
        ArrayList<PowerConsumerTarget> consumers = new ArrayList<PowerConsumerTarget>();
        this.iteratePowerFieldPositions(pos -> {
            BlockEntity blockEntity;
            BlockPos immutablePos = pos.m_7949_();
            if (this.applyPowerToBlock(immutablePos, true)) {
                newlyPowered.add(immutablePos);
            }
            if ((blockEntity = this.f_58857_.m_7702_(immutablePos)) != null) {
                blockEntity.getCapability(ElectricityCapabilities.ELECTRIC_CONSUMER, null).ifPresent(consumer -> consumers.add(new PowerConsumerTarget(immutablePos, (IElectricPowerConsumer)consumer)));
            }
        });
        this.distributePowerToConsumers(consumers);
        this.poweredBlocks.clear();
        this.poweredBlocks.addAll(newlyPowered);
    }

    private void deactivatePowerField() {
        if (this.f_58857_ == null) {
            return;
        }
        PowerFieldManager.clearSource(this.f_58858_);
        for (BlockPos pos : this.poweredBlocks) {
            this.applyPowerToBlock(pos, false);
        }
        this.notifyConsumersOfShutdown();
        this.poweredBlocks.clear();
        this.powerFieldActive = false;
    }

    private void iteratePowerFieldPositions(Consumer<BlockPos.MutableBlockPos> consumer) {
        BlockPos origin = this.m_58899_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int radius = Math.max(1, ElectricityServerConfig.powerBoxRadius());
        int radiusSq = radius * radius;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    int distSq = dx * dx + dy * dy + dz * dz;
                    if (distSq > radiusSq || dx == 0 && dy == 0 && dz == 0) continue;
                    mutable.m_122178_(origin.m_123341_() + dx, origin.m_123342_() + dy, origin.m_123343_() + dz);
                    consumer.accept(mutable);
                }
            }
        }
    }

    private boolean applyPowerToBlock(BlockPos pos, boolean powered) {
        if (this.f_58857_ == null) {
            return false;
        }
        BlockState state = this.f_58857_.m_8055_(pos);
        if (state.m_60795_()) {
            return false;
        }
        BooleanProperty property = this.findPowerProperty(state);
        if (property == null || (Boolean)state.m_61143_((Property)property) == powered) {
            return property != null;
        }
        BlockState newState = (BlockState)state.m_61124_((Property)property, (Comparable)Boolean.valueOf(powered));
        this.f_58857_.m_7731_(pos, newState, 3);
        return true;
    }

    private void distributePowerToConsumers(List<PowerConsumerTarget> consumers) {
        double available;
        double demand;
        if (consumers.isEmpty() || this.f_58857_ == null) {
            return;
        }
        int count = consumers.size();
        double[] demands = new double[count];
        double[] minimums = new double[count];
        double totalDemand = 0.0;
        for (int i = 0; i < count; ++i) {
            PowerConsumerTarget target = consumers.get(i);
            double required = Math.max(0.0, target.requiredPower());
            double minimum = Math.max(0.0, target.consumer().getMinimumOperationalPower());
            demands[i] = demand = Math.max(required, minimum);
            minimums[i] = minimum;
            totalDemand += demand;
        }
        double effectiveAvailable = available = Math.max(0.0, this.currentPower);
        for (int i = 0; i < count; ++i) {
            PowerConsumerTarget target = consumers.get(i);
            demand = demands[i];
            double minimum = minimums[i];
            double share = totalDemand <= 0.0 ? effectiveAvailable : effectiveAvailable * (demand / totalDemand);
            double maxDemand = demand * 1.1;
            double regulated = Math.min(share, maxDemand);
            regulated *= 0.92;
            PowerDeliveryEvent event = this.incomingEvent != null ? this.incomingEvent : PowerDeliveryEvent.none();
            boolean trip = this.breakerTripped;
            if (event.surgeSeverity() > 0.85 && event.surgeDuration() > 4) {
                double tripChance = 0.1 + (event.surgeSeverity() - 0.85) * 0.4;
                if (event.surgeDuration() > 8) {
                    tripChance += 0.1;
                }
                if (share < minimum * 0.5) {
                    tripChance += 0.05;
                }
                if (tripChance > 0.0 && this.f_58857_.m_213780_().m_188500_() < tripChance) {
                    trip = true;
                    this.breakerTripped = true;
                    this.breakerCooldown = 60;
                }
            }
            if (this.breakerTripped) {
                trip = true;
            }
            if (event.disconnectActive()) {
                regulated = 0.0;
                trip = true;
            } else if (event.brownoutFactor() < 1.0) {
                regulated *= Mth.m_14008_((double)event.brownoutFactor(), (double)0.0, (double)1.0);
            }
            PowerDeliveryEvent consumerEvent = event;
            if (trip) {
                regulated = 0.0;
                consumerEvent = new PowerDeliveryEvent(event.surgeSeverity(), Math.max(event.surgeDuration(), 4), true, 0.0);
            } else if (demand > 0.0 && regulated < demand) {
                double brownout = Mth.m_14008_((double)(regulated / demand), (double)0.0, (double)1.0);
                consumerEvent = new PowerDeliveryEvent(event.surgeSeverity(), event.surgeDuration(), false, brownout);
            }
            boolean meets = regulated >= minimum;
            target.consumer().onPowerSupplied(regulated, meets, consumerEvent);
            PowerFieldManager.markPowered(this.f_58858_, target.position(), regulated);
        }
    }

    private void notifyConsumersOfShutdown() {
        if (this.f_58857_ == null) {
            return;
        }
        this.iteratePowerFieldPositions(pos -> {
            BlockEntity blockEntity = this.f_58857_.m_7702_((BlockPos)pos);
            if (blockEntity != null) {
                blockEntity.getCapability(ElectricityCapabilities.ELECTRIC_CONSUMER, null).ifPresent(consumer -> consumer.onPowerSupplied(0.0, false, PowerDeliveryEvent.none()));
            }
        });
    }

    public void setIncomingEvent(PowerDeliveryEvent event) {
        this.incomingEvent = event != null ? event : PowerDeliveryEvent.none();
    }

    private BooleanProperty findPowerProperty(BlockState state) {
        for (Property property : state.m_61147_()) {
            if (!(property instanceof BooleanProperty)) continue;
            BooleanProperty boolProp = (BooleanProperty)property;
            for (String target : POWER_PROPERTY_NAMES) {
                if (!property.m_61708_().equalsIgnoreCase(target)) continue;
                return boolProp;
            }
        }
        return null;
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        int i;
        super.m_142466_(tag);
        if (tag.m_128425_("wirePositions", 9)) {
            ListTag wirePositionsList = tag.m_128437_("wirePositions", 10);
            for (i = 0; i < Math.min(wirePositionsList.size(), this.wirePositions.length); ++i) {
                CompoundTag posTag = wirePositionsList.m_128728_(i);
                if (!posTag.m_128441_("x") || !posTag.m_128441_("y") || !posTag.m_128441_("z")) continue;
                this.wirePositions[i] = new Vec3(posTag.m_128459_("x"), posTag.m_128459_("y"), posTag.m_128459_("z"));
            }
        }
        if (tag.m_128425_("insulatorIds", 9)) {
            ListTag insulatorIdsList = tag.m_128437_("insulatorIds", 3);
            for (i = 0; i < Math.min(insulatorIdsList.size(), this.insulatorIds.length); ++i) {
                this.insulatorIds[i] = insulatorIdsList.m_128763_(i);
                InsulatorIdRegistry.registerExistingId(this.insulatorIds[i]);
            }
        } else {
            this.generateInsulatorIds();
        }
        if (tag.m_128441_("currentPower")) {
            this.currentPower = tag.m_128459_("currentPower");
        }
        this.updateWirePositions();
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        ListTag wirePositionsList = new ListTag();
        for (Vec3 pos : this.wirePositions) {
            if (pos != null) {
                CompoundTag posTag = new CompoundTag();
                posTag.m_128347_("x", pos.f_82479_);
                posTag.m_128347_("y", pos.f_82480_);
                posTag.m_128347_("z", pos.f_82481_);
                wirePositionsList.add((Object)posTag);
                continue;
            }
            wirePositionsList.add((Object)new CompoundTag());
        }
        tag.m_128365_("wirePositions", (Tag)wirePositionsList);
        ListTag insulatorIdsList = new ListTag();
        for (int id : this.insulatorIds) {
            insulatorIdsList.add((Object)IntTag.m_128679_((int)id));
        }
        tag.m_128365_("insulatorIds", (Tag)insulatorIdsList);
        tag.m_128347_("currentPower", this.currentPower);
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onLoad() {
        super.onLoad();
        this.updateWirePositions();
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                TrackedBlockEntities.track(this);
                InsulatorLookup.register(this);
                WireManagerClient.invalidateInsulatorCache(this.getInsulatorIds());
            });
        }
    }

    public void m_7651_() {
        super.m_7651_();
        InsulatorIdRegistry.releaseIds(this.getInsulatorIds());
        if (this.powerFieldActive && this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.deactivatePowerField();
        }
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                TrackedBlockEntities.untrack(this);
                InsulatorLookup.unregister(this.getInsulatorIds());
                WireManagerClient.invalidateInsulatorCache(this.getInsulatorIds());
            });
        }
    }

    private record PowerConsumerTarget(BlockPos position, IElectricPowerConsumer consumer, double requiredPower) {
        PowerConsumerTarget(BlockPos position, IElectricPowerConsumer consumer) {
            this(position, consumer, consumer.getRequiredPower());
        }
    }
}

