/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.electricity.block;

import com.dooji.electricity.block.UtilityPoleBlock;
import com.dooji.electricity.client.TrackedBlockEntities;
import com.dooji.electricity.client.render.obj.ObjBoundingBoxRegistry;
import com.dooji.electricity.client.render.obj.ObjModel;
import com.dooji.electricity.client.wire.InsulatorLookup;
import com.dooji.electricity.client.wire.WireManagerClient;
import com.dooji.electricity.main.Electricity;
import com.dooji.electricity.wire.InsulatorIdRegistry;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class UtilityPoleBlockEntity
extends BlockEntity {
    private Vec3[] wirePositions = new Vec3[8];
    private int[] insulatorIds = new int[8];
    private float offsetX = 0.0f;
    private float offsetY = 0.0f;
    private float offsetZ = 0.0f;
    private float yaw = 0.0f;
    private float pitch = 0.0f;
    private double currentPower = 0.0;

    public UtilityPoleBlockEntity(BlockPos pos, BlockState state) {
        super(UtilityPoleBlockEntity.getBlockEntityType(), pos, state);
        this.initializeWirePositions();
        this.generateInsulatorIds();
    }

    private static BlockEntityType<UtilityPoleBlockEntity> getBlockEntityType() {
        if (Electricity.UTILITY_POLE_BLOCK_ENTITY != null) {
            return (BlockEntityType)Electricity.UTILITY_POLE_BLOCK_ENTITY.get();
        }
        return null;
    }

    private void initializeWirePositions() {
        Vec3 orientedCenter;
        Vec3 center = Vec3.m_82512_((Vec3i)this.m_58899_());
        String[] insulatorGroups = new String[]{"insulator_1_Material.023", "insulator_2_Material.009", "insulator_3_Material.016", "insulator_4_Material.001", "insulator_5_Material.051", "insulator_6_Material.037", "insulator_7_Material.030", "insulator_8_Material.058"};
        boolean useDynamicPositions = false;
        for (int i = 0; i < insulatorGroups.length && i < this.wirePositions.length && (orientedCenter = this.calculateOrientedInsulatorCenter(insulatorGroups[i])) != null; ++i) {
            this.wirePositions[i] = orientedCenter;
            useDynamicPositions = true;
        }
        if (!useDynamicPositions) {
            this.wirePositions[0] = center.m_82520_(0.2, 5.5, 0.2);
            this.wirePositions[1] = center.m_82520_(-0.2, 5.5, 0.2);
            this.wirePositions[2] = center.m_82520_(0.2, 5.5, -0.2);
            this.wirePositions[3] = center.m_82520_(-0.2, 5.5, -0.2);
            this.wirePositions[4] = center.m_82520_(0.2, 4.5, 0.2);
            this.wirePositions[5] = center.m_82520_(-0.2, 4.5, 0.2);
            this.wirePositions[6] = center.m_82520_(0.2, 4.5, -0.2);
            this.wirePositions[7] = center.m_82520_(-0.2, 4.5, -0.2);
        }
    }

    private Vec3 calculateOrientedInsulatorCenter(String insulatorGroup) {
        try {
            Vector3f localCenter = ObjBoundingBoxRegistry.getCenterSafe(this.m_58900_().m_60734_(), insulatorGroup);
            if (localCenter == null) {
                return null;
            }
            Vector3f facingRotated = this.applyFacingRotation(localCenter);
            facingRotated.add(-this.offsetX, this.offsetY, -this.offsetZ);
            Vector3f rotatedCenter = this.applyYawPitchRotation(facingRotated, this.yaw, this.pitch);
            Vec3 worldPos = new Vec3((double)rotatedCenter.x, (double)rotatedCenter.y, (double)rotatedCenter.z);
            worldPos = worldPos.m_82549_(Vec3.m_82528_((Vec3i)this.m_58899_())).m_82520_(0.5, 0.0, 0.5);
            return worldPos;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Vector3f applyFacingRotation(Vector3f point) {
        float facingRotation;
        Vector3f result = new Vector3f((Vector3fc)point);
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)UtilityPoleBlock.FACING);
        switch (facing) {
            case EAST: {
                float f = 180.0f;
                break;
            }
            case SOUTH: {
                float f = 270.0f;
                break;
            }
            case WEST: {
                float f = 0.0f;
                break;
            }
            default: {
                float f = facingRotation = 90.0f;
            }
        }
        if (facingRotation != 0.0f) {
            float cosYaw = (float)Math.cos(Math.toRadians(facingRotation));
            float sinYaw = (float)Math.sin(Math.toRadians(facingRotation));
            float x = result.x * cosYaw + result.z * sinYaw;
            float z = -result.x * sinYaw + result.z * cosYaw;
            result.x = x;
            result.z = z;
        }
        return result;
    }

    private Vector3f applyYawPitchRotation(Vector3f point, float yawRadians, float pitchRadians) {
        float z;
        Vector3f result = new Vector3f((Vector3fc)point);
        if (pitchRadians != 0.0f) {
            float cosPitch = (float)Math.cos(-pitchRadians);
            float sinPitch = (float)Math.sin(-pitchRadians);
            float y = result.y * cosPitch - result.z * sinPitch;
            z = result.y * sinPitch + result.z * cosPitch;
            result.y = y;
            result.z = z;
        }
        if (yawRadians != 0.0f) {
            float cosYaw = (float)Math.cos(yawRadians);
            float sinYaw = (float)Math.sin(yawRadians);
            float x = result.x * cosYaw + result.z * sinYaw;
            z = -result.x * sinYaw + result.z * cosYaw;
            result.x = x;
            result.z = z;
        }
        return result;
    }

    public Vec3 getWirePosition(int index) {
        if (index >= 0 && index < this.wirePositions.length) {
            return this.wirePositions[index];
        }
        return Vec3.m_82512_((Vec3i)this.m_58899_());
    }

    public float getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(float offsetX) {
        this.offsetX = offsetX;
        this.updateWirePositions();
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public float getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(float offsetY) {
        this.offsetY = offsetY;
        this.updateWirePositions();
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public float getOffsetZ() {
        return this.offsetZ;
    }

    public void setOffsetZ(float offsetZ) {
        this.offsetZ = offsetZ;
        this.updateWirePositions();
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public float getYaw() {
        return this.yaw;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
        this.updateWirePositions();
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public float getPitch() {
        return this.pitch;
    }

    public double getCurrentPower() {
        return this.currentPower;
    }

    public void setCurrentPower(double power) {
        this.currentPower = power;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
        this.updateWirePositions();
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    private void updateWirePositions() {
        this.initializeWirePositions();
    }

    public ObjModel.OrientedBoundingBox getOrientedBoundingBoxForInsulator(String insulatorGroup) {
        try {
            ObjModel.BoundingBox localBbox = ObjBoundingBoxRegistry.getBoundingBox(this.m_58900_().m_60734_(), insulatorGroup);
            if (localBbox == null) {
                return null;
            }
            Vector3f worldCenter = new Vector3f((float)this.m_58899_().m_123341_() + 0.5f, (float)this.m_58899_().m_123342_(), (float)this.m_58899_().m_123343_() + 0.5f);
            Vector3f localCenter = this.applyFacingRotation(localBbox.center);
            worldCenter.add((Vector3fc)localCenter);
            worldCenter.add(this.offsetX, this.offsetY, this.offsetZ);
            return new ObjModel.OrientedBoundingBox(worldCenter, localBbox.size, this.yaw, this.pitch);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128350_("offsetX", this.offsetX);
        tag.m_128350_("offsetY", this.offsetY);
        tag.m_128350_("offsetZ", this.offsetZ);
        tag.m_128350_("yaw", this.yaw);
        tag.m_128350_("pitch", this.pitch);
        tag.m_128347_("currentPower", this.currentPower);
        ListTag insulatorIdsList = new ListTag();
        for (int insulatorId : this.insulatorIds) {
            insulatorIdsList.add((Object)IntTag.m_128679_((int)insulatorId));
        }
        tag.m_128365_("insulatorIds", (Tag)insulatorIdsList);
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.offsetX = tag.m_128457_("offsetX");
        this.offsetY = tag.m_128457_("offsetY");
        this.offsetZ = tag.m_128457_("offsetZ");
        this.yaw = tag.m_128457_("yaw");
        this.pitch = tag.m_128457_("pitch");
        this.currentPower = tag.m_128459_("currentPower");
        if (tag.m_128425_("insulatorIds", 9)) {
            ListTag insulatorIdsList = tag.m_128437_("insulatorIds", 3);
            for (int i = 0; i < Math.min(insulatorIdsList.size(), this.insulatorIds.length); ++i) {
                this.insulatorIds[i] = insulatorIdsList.m_128763_(i);
                InsulatorIdRegistry.registerExistingId(this.insulatorIds[i]);
            }
        } else {
            this.generateInsulatorIds();
        }
        this.updateWirePositions();
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128350_("offsetX", this.offsetX);
        tag.m_128350_("offsetY", this.offsetY);
        tag.m_128350_("offsetZ", this.offsetZ);
        tag.m_128350_("yaw", this.yaw);
        tag.m_128350_("pitch", this.pitch);
        tag.m_128347_("currentPower", this.currentPower);
        ListTag insulatorIdsList = new ListTag();
        for (int insulatorId : this.insulatorIds) {
            insulatorIdsList.add((Object)IntTag.m_128679_((int)insulatorId));
        }
        tag.m_128365_("insulatorIds", (Tag)insulatorIdsList);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.offsetX = tag.m_128457_("offsetX");
        this.offsetY = tag.m_128457_("offsetY");
        this.offsetZ = tag.m_128457_("offsetZ");
        this.yaw = tag.m_128457_("yaw");
        this.pitch = tag.m_128457_("pitch");
        this.currentPower = tag.m_128459_("currentPower");
        if (tag.m_128425_("insulatorIds", 9)) {
            ListTag insulatorIdsList = tag.m_128437_("insulatorIds", 3);
            for (int i = 0; i < Math.min(insulatorIdsList.size(), this.insulatorIds.length); ++i) {
                this.insulatorIds[i] = insulatorIdsList.m_128763_(i);
                InsulatorIdRegistry.registerExistingId(this.insulatorIds[i]);
            }
        }
        this.updateWirePositions();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            InsulatorLookup.register(this);
            WireManagerClient.invalidateInsulatorCache(this.getInsulatorIds());
        });
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.handleUpdateTag(packet.m_131708_());
    }

    private void generateInsulatorIds() {
        for (int i = 0; i < this.insulatorIds.length; ++i) {
            if (this.insulatorIds[i] != 0) continue;
            this.insulatorIds[i] = InsulatorIdRegistry.claimId();
        }
    }

    public int getInsulatorId(int index) {
        if (index >= 0 && index < this.insulatorIds.length) {
            return this.insulatorIds[index];
        }
        return -1;
    }

    public int[] getInsulatorIds() {
        return (int[])this.insulatorIds.clone();
    }

    public static void removeInsulatorIds(int[] ids) {
        InsulatorIdRegistry.releaseIds(ids);
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                TrackedBlockEntities.track(this);
                InsulatorLookup.register(this);
                WireManagerClient.invalidateInsulatorCache(this.getInsulatorIds());
            });
        }
    }

    public void m_7651_() {
        super.m_7651_();
        InsulatorIdRegistry.releaseIds(this.getInsulatorIds());
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                TrackedBlockEntities.untrack(this);
                InsulatorLookup.unregister(this.getInsulatorIds());
                WireManagerClient.invalidateInsulatorCache(this.getInsulatorIds());
            });
        }
    }
}

