/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.electricity.block;

import com.dooji.electricity.block.WindTurbineBlock;
import com.dooji.electricity.client.TrackedBlockEntities;
import com.dooji.electricity.client.render.obj.ObjBoundingBoxRegistry;
import com.dooji.electricity.client.render.obj.ObjModel;
import com.dooji.electricity.client.wire.InsulatorLookup;
import com.dooji.electricity.client.wire.WireManagerClient;
import com.dooji.electricity.main.Electricity;
import com.dooji.electricity.main.weather.GlobalWeatherManager;
import com.dooji.electricity.main.weather.WeatherSnapshot;
import com.dooji.electricity.wire.InsulatorIdRegistry;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import org.joml.Vector3f;

public class WindTurbineBlockEntity
extends BlockEntity {
    private Vec3[] wirePositions = new Vec3[1];
    private int[] insulatorIds = new int[1];
    private float rotationSpeed1 = 0.0f;
    private float rotationSpeed2 = 0.0f;
    private float rotation1 = 0.0f;
    private float rotation2 = 0.0f;
    private double generatedPower = 0.0;
    private double currentPower = 0.0;
    private static final Vec3 DEFAULT_INSULATOR_OFFSET = new Vec3(0.0, 9.5, -0.5);
    private float lastEffectiveWindSpeed = 0.0f;
    private float windDirection = 0.0f;
    private double turbulence = 0.0;
    private static final float CUTOFF_RESET_SPEED = 20.0f;
    private boolean cutOutActive = false;
    private static final float CUT_IN_SPEED = 3.0f;
    private static final float RATED_SPEED = 12.0f;
    private static final float CUTOFF_SPEED = 22.0f;

    public WindTurbineBlockEntity(BlockPos pos, BlockState state) {
        super(WindTurbineBlockEntity.getBlockEntityType(), pos, state);
        this.initializeWirePositions();
        this.generateInsulatorIds();
    }

    private static BlockEntityType<WindTurbineBlockEntity> getBlockEntityType() {
        return (BlockEntityType)Electricity.WIND_TURBINE_BLOCK_ENTITY.get();
    }

    private void initializeWirePositions() {
        for (int i = 0; i < this.wirePositions.length; ++i) {
            this.wirePositions[i] = this.calculateOrientedInsulatorCenter(i);
        }
    }

    private void generateInsulatorIds() {
        for (int i = 0; i < this.insulatorIds.length; ++i) {
            this.insulatorIds[i] = InsulatorIdRegistry.claimId();
        }
    }

    public static void removeInsulatorIds(int[] ids) {
        InsulatorIdRegistry.releaseIds(ids);
    }

    public Vec3 getWirePosition(int index) {
        if (index >= 0 && index < this.wirePositions.length) {
            return this.wirePositions[index];
        }
        return null;
    }

    public void setWirePosition(int index, Vec3 position) {
        if (index >= 0 && index < this.wirePositions.length) {
            this.wirePositions[index] = position;
        }
    }

    public int getInsulatorId(int index) {
        if (index >= 0 && index < this.insulatorIds.length) {
            return this.insulatorIds[index];
        }
        return -1;
    }

    public int[] getInsulatorIds() {
        return (int[])this.insulatorIds.clone();
    }

    public float getRotation1() {
        return this.rotation1;
    }

    public float getRotation2() {
        return this.rotation2;
    }

    public float getWindSpeed() {
        return this.lastEffectiveWindSpeed;
    }

    public float getWindDirection() {
        return this.windDirection;
    }

    public double getGeneratedPower() {
        this.updateGeneratedPower();
        return this.generatedPower;
    }

    public boolean isSurging() {
        return this.turbulence >= 0.35 && this.lastEffectiveWindSpeed < 22.0f && !this.cutOutActive;
    }

    public double getCurrentPower() {
        return this.currentPower;
    }

    public void setCurrentPower(double power) {
        this.currentPower = power;
    }

    private void updateGeneratedPower() {
        float effectiveWindSpeed = Math.max(0.0f, this.lastEffectiveWindSpeed);
        if (this.cutOutActive || effectiveWindSpeed < 3.0f || effectiveWindSpeed >= 22.0f) {
            this.generatedPower = 0.0;
            return;
        }
        float capped = Math.min(effectiveWindSpeed, 12.0f);
        double normalized = Math.min(1.0, (double)(capped / 16.0f));
        double energyFactor = normalized * normalized;
        this.generatedPower = 140.0 * energyFactor;
    }

    public Vec3 calculateOrientedInsulatorCenter(int index) {
        Vec3 localCenter;
        if (index != 0) {
            return null;
        }
        String groupName = "insulator_Plastic";
        ObjModel.BoundingBox boundingBox = ObjBoundingBoxRegistry.getBoundingBox((Block)Electricity.WIND_TURBINE_BLOCK.get(), groupName);
        if (boundingBox != null) {
            Vector3f center = boundingBox.center;
            localCenter = new Vec3((double)center.x(), (double)center.y(), (double)center.z());
        } else {
            localCenter = DEFAULT_INSULATOR_OFFSET;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)WindTurbineBlock.FACING);
        Vec3 rotatedCenter = this.rotateVector(localCenter, facing);
        return Vec3.m_82528_((Vec3i)this.m_58899_()).m_82520_(0.5, 0.0, 0.5).m_82549_(rotatedCenter);
    }

    private Vec3 rotateVector(Vec3 vector, Direction facing) {
        float facingRotation = switch (facing) {
            case Direction.EAST -> 90.0f;
            case Direction.SOUTH -> 0.0f;
            case Direction.WEST -> 270.0f;
            default -> 180.0f;
        };
        double radians = Math.toRadians(facingRotation);
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        double newX = vector.f_82479_ * cos - vector.f_82481_ * sin;
        double newZ = vector.f_82479_ * sin + vector.f_82481_ * cos;
        return new Vec3(newX, vector.f_82480_, newZ);
    }

    public void tick() {
        this.updateWirePositions();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            InsulatorLookup.register(this);
            WireManagerClient.invalidateInsulatorCache(this.getInsulatorIds());
        });
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            this.clientVisualTick();
            return;
        }
        WeatherSnapshot weather = GlobalWeatherManager.get((ServerLevel)this.f_58857_).sample(this.f_58858_);
        float sustained = (float)weather.windSpeed();
        float gust = (float)weather.gustSpeed();
        float blend = Mth.m_14036_((float)((float)weather.turbulence()), (float)0.0f, (float)1.0f);
        this.lastEffectiveWindSpeed = Mth.m_14179_((float)blend, (float)sustained, (float)gust);
        this.windDirection = weather.direction();
        this.turbulence = weather.turbulence();
        if (this.lastEffectiveWindSpeed >= 22.0f) {
            this.cutOutActive = true;
        } else if (this.cutOutActive && this.lastEffectiveWindSpeed <= 20.0f) {
            this.cutOutActive = false;
        }
        this.updateRotorSpeeds(this.lastEffectiveWindSpeed, this.turbulence, this.cutOutActive);
        this.updateGeneratedPower();
        if ((this.f_58857_.m_46467_() & 3L) == 0L) {
            this.syncStateToClients();
        }
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        int i;
        super.m_142466_(tag);
        if (tag.m_128441_("wirePositions")) {
            ListTag positionsList = tag.m_128437_("wirePositions", 10);
            for (i = 0; i < Math.min(positionsList.size(), this.wirePositions.length); ++i) {
                CompoundTag posTag = positionsList.m_128728_(i);
                this.wirePositions[i] = new Vec3(posTag.m_128459_("x"), posTag.m_128459_("y"), posTag.m_128459_("z"));
            }
        }
        if (tag.m_128441_("insulatorIds")) {
            ListTag insulatorIdsList = tag.m_128437_("insulatorIds", 3);
            for (i = 0; i < Math.min(insulatorIdsList.size(), this.insulatorIds.length); ++i) {
                this.insulatorIds[i] = insulatorIdsList.m_128763_(i);
                InsulatorIdRegistry.registerExistingId(this.insulatorIds[i]);
            }
        }
        this.rotationSpeed1 = tag.m_128457_("rotationSpeed1");
        this.rotationSpeed2 = tag.m_128457_("rotationSpeed2");
        this.generatedPower = tag.m_128459_("generatedPower");
        this.currentPower = tag.m_128459_("currentPower");
        this.lastEffectiveWindSpeed = tag.m_128457_("lastEffectiveWindSpeed");
        this.cutOutActive = tag.m_128441_("cutOutActive") && tag.m_128471_("cutOutActive");
        this.windDirection = tag.m_128457_("windDirection");
        this.turbulence = tag.m_128441_("turbulence") ? tag.m_128459_("turbulence") : 0.0;
        this.updateWirePositions();
    }

    private void updateWirePositions() {
        for (int i = 0; i < this.wirePositions.length; ++i) {
            Vec3 calculatedPos = this.calculateOrientedInsulatorCenter(i);
            if (calculatedPos == null) continue;
            this.wirePositions[i] = calculatedPos;
        }
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        ListTag positionsList = new ListTag();
        for (Vec3 pos : this.wirePositions) {
            CompoundTag posTag = new CompoundTag();
            posTag.m_128347_("x", pos.f_82479_);
            posTag.m_128347_("y", pos.f_82480_);
            posTag.m_128347_("z", pos.f_82481_);
            positionsList.add((Object)posTag);
        }
        tag.m_128365_("wirePositions", (Tag)positionsList);
        ListTag insulatorIdsList = new ListTag();
        for (int id : this.insulatorIds) {
            insulatorIdsList.add((Object)IntTag.m_128679_((int)id));
        }
        tag.m_128365_("insulatorIds", (Tag)insulatorIdsList);
        tag.m_128350_("rotationSpeed1", this.rotationSpeed1);
        tag.m_128350_("rotationSpeed2", this.rotationSpeed2);
        tag.m_128347_("generatedPower", this.generatedPower);
        tag.m_128347_("currentPower", this.currentPower);
        tag.m_128350_("lastEffectiveWindSpeed", this.lastEffectiveWindSpeed);
        tag.m_128379_("cutOutActive", this.cutOutActive);
        tag.m_128350_("windDirection", this.windDirection);
        tag.m_128347_("turbulence", this.turbulence);
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                TrackedBlockEntities.track(this);
                InsulatorLookup.register(this);
                WireManagerClient.invalidateInsulatorCache(this.getInsulatorIds());
            });
        }
    }

    public void m_7651_() {
        super.m_7651_();
        InsulatorIdRegistry.releaseIds(this.getInsulatorIds());
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                TrackedBlockEntities.untrack(this);
                InsulatorLookup.unregister(this.getInsulatorIds());
                WireManagerClient.invalidateInsulatorCache(this.getInsulatorIds());
            });
        }
    }

    private void syncStateToClients() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
    }

    private void updateRotorSpeeds(float effectiveWindSpeed, double turbulence, boolean cutOut) {
        float maxRotationSpeed = Math.min(12.0f, 6.0f + effectiveWindSpeed * 0.5f);
        float rotationScale = Mth.m_14179_((float)((float)Mth.m_14008_((double)turbulence, (double)0.0, (double)1.0)), (float)0.45f, (float)0.8f);
        float targetRotationSpeed = cutOut ? 0.0f : Math.min(maxRotationSpeed, effectiveWindSpeed * rotationScale);
        float rotationAcceleration = cutOut ? 0.12f : 0.05f;
        float rotationDiff1 = targetRotationSpeed - this.rotationSpeed1;
        float rotationDiff2 = targetRotationSpeed - this.rotationSpeed2;
        if (Math.abs(rotationDiff1) > 0.001f) {
            this.rotationSpeed1 += rotationDiff1 * rotationAcceleration;
        }
        if (Math.abs(rotationDiff2) > 0.001f) {
            this.rotationSpeed2 += rotationDiff2 * rotationAcceleration;
        }
        if (cutOut) {
            if (Math.abs(this.rotationSpeed1) < 0.01f) {
                this.rotationSpeed1 = 0.0f;
            }
            if (Math.abs(this.rotationSpeed2) < 0.01f) {
                this.rotationSpeed2 = 0.0f;
            }
        }
    }

    private void clientVisualTick() {
        float effectiveSpeed = this.lastEffectiveWindSpeed;
        float currentTime = (float)this.f_58857_.m_46467_() + (float)this.f_58857_.m_46467_() * 0.05f;
        this.advanceRotations(currentTime, effectiveSpeed);
    }

    private void advanceRotations(float currentTime, float effectiveSpeed) {
        float variation1 = 1.0f + (float)Math.sin((double)currentTime * 0.05) * 0.1f;
        float variation2 = 1.0f + (float)Math.cos((double)currentTime * 0.07) * 0.1f;
        float appliedSpeed1 = this.rotationSpeed1;
        float appliedSpeed2 = this.rotationSpeed2;
        if (!this.cutOutActive) {
            if (this.rotationSpeed1 == 0.0f && effectiveSpeed > 0.0f) {
                appliedSpeed1 = Math.min(12.0f, effectiveSpeed * 0.6f);
            }
            if (this.rotationSpeed2 == 0.0f && effectiveSpeed > 0.0f) {
                appliedSpeed2 = appliedSpeed1;
            }
        }
        this.rotation1 = (this.rotation1 + appliedSpeed1 * variation1) % 360.0f;
        this.rotation2 = (this.rotation2 + appliedSpeed2 * variation2) % 360.0f;
        if (this.rotation1 < 0.0f) {
            this.rotation1 += 360.0f;
        }
        if (this.rotation2 < 0.0f) {
            this.rotation2 += 360.0f;
        }
    }
}

