/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.electricity.client;

import com.dooji.electricity.block.ElectricCabinBlockEntity;
import com.dooji.electricity.block.PowerBoxBlockEntity;
import com.dooji.electricity.block.UtilityPoleBlockEntity;
import com.dooji.electricity.block.WindTurbineBlockEntity;
import com.dooji.electricity.client.ElectricityClientConfig;
import com.dooji.electricity.client.TrackedBlockEntities;
import com.dooji.electricity.client.render.block.ElectricCabinRenderer;
import com.dooji.electricity.client.render.block.PowerBoxRenderer;
import com.dooji.electricity.client.render.block.UtilityPoleRenderer;
import com.dooji.electricity.client.render.block.WindTurbineRenderer;
import com.dooji.electricity.client.wire.InsulatorLookup;
import com.dooji.electricity.client.wire.WireManagerClient;
import com.dooji.electricity.main.network.payloads.PowerUpdatePayload;
import com.dooji.electricity.main.network.payloads.SyncWiresPayload;
import com.dooji.electricity.main.network.payloads.WireConnectionPayload;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="electricity", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ElectricityClient {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.addListener(ElectricityClient::onLevelUnload);
        MinecraftForge.EVENT_BUS.addListener(ElectricityClient::onClientDisconnect);
        ElectricityClient.setupRenderers();
    }

    private static void setupRenderers() {
        UtilityPoleRenderer.init();
        ElectricCabinRenderer.init();
        PowerBoxRenderer.init();
        WindTurbineRenderer.init();
    }

    private static void onClientDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
        WireManagerClient.removeAll();
        TrackedBlockEntities.clear();
        InsulatorLookup.clear();
    }

    private static void onLevelUnload(LevelEvent.Unload event) {
        if (event.getLevel().m_5776_()) {
            WireManagerClient.removeAll();
            TrackedBlockEntities.clear();
            InsulatorLookup.clear();
        }
    }

    public static void handleSyncPacket(SyncWiresPayload payload) {
        WireManagerClient.sync(payload.connections());
    }

    public static void handleWireConnectionPacket(WireConnectionPayload payload) {
        if (payload.isCreation()) {
            WireManagerClient.addWireConnection(payload.connection());
        } else {
            WireManagerClient.removeWireConnection(payload.connection());
        }
    }

    public static void handlePowerUpdatePacket(PowerUpdatePayload payload) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(payload.blockPos());
        if (blockEntity instanceof WindTurbineBlockEntity) {
            WindTurbineBlockEntity turbine = (WindTurbineBlockEntity)blockEntity;
            turbine.setCurrentPower(payload.power());
        } else if (blockEntity instanceof ElectricCabinBlockEntity) {
            ElectricCabinBlockEntity cabin = (ElectricCabinBlockEntity)blockEntity;
            cabin.setCurrentPower(payload.power());
        } else if (blockEntity instanceof UtilityPoleBlockEntity) {
            UtilityPoleBlockEntity pole = (UtilityPoleBlockEntity)blockEntity;
            pole.setCurrentPower(payload.power());
        } else if (blockEntity instanceof PowerBoxBlockEntity) {
            PowerBoxBlockEntity powerBox = (PowerBoxBlockEntity)blockEntity;
            powerBox.setCurrentPower(payload.power());
        }
    }

    static {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ElectricityClientConfig.spec(), "Electricity/config.toml");
    }
}

