/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.electricity.client;

import com.dooji.electricity.block.UtilityPoleBlockEntity;
import com.dooji.electricity.main.network.ElectricityNetworking;
import com.dooji.electricity.main.network.payloads.UpdateUtilityPoleConfigPayload;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;

public class UtilityPoleConfigScreen
extends Screen {
    private Button doneButton;
    private Button cancelButton;
    private final BlockPos blockPos;
    private float offsetX = 0.0f;
    private float offsetY = 0.0f;
    private float offsetZ = 0.0f;
    private float yaw = 0.0f;
    private float pitch = 0.0f;

    public UtilityPoleConfigScreen(BlockPos blockPos) {
        super((Component)Component.m_237115_((String)"screen.electricity.utility_pole_config.title"));
        BlockEntity blockEntity;
        this.blockPos = blockPos;
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ != null && (blockEntity = minecraft.f_91073_.m_7702_(blockPos)) instanceof UtilityPoleBlockEntity) {
            UtilityPoleBlockEntity entity = (UtilityPoleBlockEntity)blockEntity;
            this.offsetX = entity.getOffsetX();
            this.offsetY = entity.getOffsetY();
            this.offsetZ = entity.getOffsetZ();
            this.yaw = entity.getYaw();
            this.pitch = entity.getPitch();
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int fieldWidth = 60;
        int fieldHeight = 20;
        int spacing = 24;
        this.m_142416_((GuiEventListener)this.createFloatField(centerX - 100, centerY - 60, fieldWidth, fieldHeight, (Component)Component.m_237115_((String)"screen.electricity.utility_pole_config.offset_x"), this.offsetX, value -> {
            this.offsetX = value.floatValue();
        }));
        this.m_142416_((GuiEventListener)this.createFloatField(centerX - 100, centerY - 60 + spacing, fieldWidth, fieldHeight, (Component)Component.m_237115_((String)"screen.electricity.utility_pole_config.offset_y"), this.offsetY, value -> {
            this.offsetY = value.floatValue();
        }));
        this.m_142416_((GuiEventListener)this.createFloatField(centerX - 100, centerY - 60 + spacing * 2, fieldWidth, fieldHeight, (Component)Component.m_237115_((String)"screen.electricity.utility_pole_config.offset_z"), this.offsetZ, value -> {
            this.offsetZ = value.floatValue();
        }));
        this.m_142416_((GuiEventListener)this.createDegreeField(centerX + 20, centerY - 60, fieldWidth, fieldHeight, (Component)Component.m_237115_((String)"screen.electricity.utility_pole_config.yaw"), this.yaw, value -> {
            this.yaw = value.floatValue();
        }));
        this.m_142416_((GuiEventListener)this.createDegreeField(centerX + 20, centerY - 60 + spacing, fieldWidth, fieldHeight, (Component)Component.m_237115_((String)"screen.electricity.utility_pole_config.pitch"), this.pitch, value -> {
            this.pitch = value.floatValue();
        }));
        this.doneButton = Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.saveAndClose()).m_252987_(centerX - 100, centerY + 40, 80, 20).m_253136_();
        this.cancelButton = Button.m_253074_((Component)CommonComponents.f_130656_, button -> this.m_7379_()).m_252987_(centerX + 20, centerY + 40, 80, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.doneButton);
        this.m_142416_((GuiEventListener)this.cancelButton);
    }

    private void saveAndClose() {
        UpdateUtilityPoleConfigPayload payload = new UpdateUtilityPoleConfigPayload(this.blockPos, this.offsetX, this.offsetY, this.offsetZ, this.yaw, this.pitch);
        ElectricityNetworking.INSTANCE.sendToServer((Object)payload);
        this.m_7379_();
    }

    public void m_88315_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"screen.electricity.utility_pole_config.offset_x"), centerX - 160, centerY - 55, 0xFFFFFF, false);
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"screen.electricity.utility_pole_config.offset_y"), centerX - 160, centerY - 31, 0xFFFFFF, false);
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"screen.electricity.utility_pole_config.offset_z"), centerX - 160, centerY - 7, 0xFFFFFF, false);
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"screen.electricity.utility_pole_config.yaw"), centerX - 40, centerY - 55, 0xFFFFFF, false);
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"screen.electricity.utility_pole_config.pitch"), centerX - 40, centerY - 31, 0xFFFFFF, false);
    }

    public boolean m_7043_() {
        return false;
    }

    private static String formatDegrees(float radians) {
        return String.format("%.2f", Math.toDegrees(radians));
    }

    private EditBox createFloatField(int x, int y, int width, int height, Component label, float initialValue, Consumer<Float> setter) {
        EditBox field = new EditBox(this.f_96547_, x, y, width, height, label);
        field.m_94144_(Float.toString(initialValue));
        field.m_94151_(value -> {
            Float parsed = UtilityPoleConfigScreen.tryParseFloat(value);
            if (parsed != null) {
                setter.accept(parsed);
            }
        });
        return field;
    }

    private EditBox createDegreeField(int x, int y, int width, int height, Component label, float initialRadians, Consumer<Float> setter) {
        EditBox field = new EditBox(this.f_96547_, x, y, width, height, label);
        field.m_94144_(UtilityPoleConfigScreen.formatDegrees(initialRadians));
        field.m_94151_(value -> {
            Float parsed = UtilityPoleConfigScreen.tryParseFloat(value);
            if (parsed != null) {
                setter.accept(Float.valueOf((float)Math.toRadians(parsed.floatValue())));
            }
        });
        return field;
    }

    private static Float tryParseFloat(String value) {
        try {
            return Float.valueOf(Float.parseFloat(value));
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }
}

