/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.electricity.client.events;

import com.dooji.electricity.block.ElectricCabinBlock;
import com.dooji.electricity.block.ElectricCabinBlockEntity;
import com.dooji.electricity.block.PowerBoxBlock;
import com.dooji.electricity.block.PowerBoxBlockEntity;
import com.dooji.electricity.block.UtilityPoleBlock;
import com.dooji.electricity.block.UtilityPoleBlockEntity;
import com.dooji.electricity.block.WindTurbineBlock;
import com.dooji.electricity.block.WindTurbineBlockEntity;
import com.dooji.electricity.client.render.obj.ObjRaycaster;
import com.dooji.electricity.client.wire.WireAnchorHelper;
import com.dooji.electricity.client.wire.WireManagerClient;
import com.dooji.electricity.item.ItemWire;
import com.dooji.electricity.main.network.ElectricityNetworking;
import com.dooji.electricity.main.network.payloads.CreateWireFromInsulatorsPayload;
import com.dooji.electricity.wire.InsulatorPartHelper;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="electricity", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WireInteractionEvents {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onRightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        InteractionHand hand = InteractionHand.MAIN_HAND;
        ItemStack heldItem = player.m_21120_(hand);
        if (!(heldItem.m_41720_() instanceof ItemWire) && !((heldItem = player.m_21120_(hand = InteractionHand.OFF_HAND)).m_41720_() instanceof ItemWire)) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        Vec3 cameraPos = mc.f_91074_.m_146892_();
        Vec3 lookDirection = mc.f_91074_.m_20154_();
        int range = 16;
        BlockPos playerPos = mc.f_91074_.m_20183_();
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    String hoveredPart;
                    BlockPos checkPos = playerPos.m_7918_(x, y, z);
                    BlockEntity blockEntity = mc.f_91073_.m_7702_(checkPos);
                    if (blockEntity == null || (hoveredPart = ObjRaycaster.getHoveredPart(cameraPos, lookDirection, checkPos)) == null) continue;
                    BlockState blockState = mc.f_91073_.m_8055_(checkPos);
                    Direction facing = null;
                    if (blockState.m_61138_((Property)UtilityPoleBlock.FACING)) {
                        facing = (Direction)blockState.m_61143_((Property)UtilityPoleBlock.FACING);
                    } else if (blockState.m_61138_((Property)ElectricCabinBlock.FACING)) {
                        facing = (Direction)blockState.m_61143_((Property)ElectricCabinBlock.FACING);
                    } else if (blockState.m_61138_((Property)PowerBoxBlock.FACING)) {
                        facing = (Direction)blockState.m_61143_((Property)PowerBoxBlock.FACING);
                    } else if (blockState.m_61138_((Property)WindTurbineBlock.FACING)) {
                        facing = (Direction)blockState.m_61143_((Property)WindTurbineBlock.FACING);
                    }
                    Vec3 fallback = ObjRaycaster.getPartCenter(checkPos, hoveredPart, facing);
                    Vec3 partCenter = WireAnchorHelper.anchorOrFallback(blockEntity, hoveredPart, fallback);
                    if (partCenter == null) continue;
                    WireInteractionEvents.handleOBJPartClick(player, hand, partCenter, checkPos, hoveredPart);
                    return;
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleOBJPartClick(Player player, InteractionHand hand, Vec3 connectionPoint, BlockPos blockPos, String partName) {
        Vec3 pendingPos = WireManagerClient.getPendingConnection();
        String pendingPartName = WireManagerClient.getPendingPartName();
        boolean performedAction = false;
        if (pendingPos == null) {
            WireManagerClient.setPendingConnection(connectionPoint, blockPos);
            WireManagerClient.setPendingPartName(partName);
            performedAction = true;
        } else if (!pendingPos.equals((Object)connectionPoint)) {
            BlockPos pendingBlockPos = WireManagerClient.getPendingBlockPos();
            WireManagerClient.clearPendingConnection();
            performedAction = WireInteractionEvents.createWireFromInsulators(pendingBlockPos, blockPos, pendingPartName, partName);
        } else {
            WireManagerClient.clearPendingConnection();
        }
        if (performedAction && player != null) {
            player.m_6674_(hand);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean createWireFromInsulators(BlockPos startBlockPos, BlockPos endBlockPos, String startPartName, String endPartName) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return false;
        }
        BlockEntity startEntity = level.m_7702_(startBlockPos);
        BlockEntity endEntity = level.m_7702_(endBlockPos);
        if (!((startEntity instanceof UtilityPoleBlockEntity || startEntity instanceof ElectricCabinBlockEntity || startEntity instanceof PowerBoxBlockEntity || startEntity instanceof WindTurbineBlockEntity) && (endEntity instanceof UtilityPoleBlockEntity || endEntity instanceof ElectricCabinBlockEntity || endEntity instanceof PowerBoxBlockEntity || endEntity instanceof WindTurbineBlockEntity))) {
            return false;
        }
        Optional<InsulatorPartHelper.Insulator> start = InsulatorPartHelper.resolve(startEntity, startPartName);
        Optional<InsulatorPartHelper.Insulator> end = InsulatorPartHelper.resolve(endEntity, endPartName);
        if (start.isEmpty() || end.isEmpty()) {
            return false;
        }
        String startBlockType = start.get().blockType();
        String endBlockType = end.get().blockType();
        String startPowerType = InsulatorPartHelper.determinePowerType(startEntity, startPartName);
        String endPowerType = InsulatorPartHelper.determinePowerType(endEntity, endPartName);
        CreateWireFromInsulatorsPayload payload = new CreateWireFromInsulatorsPayload(start.get().insulatorId(), end.get().insulatorId(), startBlockPos, endBlockPos, startBlockType, endBlockType, startPowerType, endPowerType);
        ElectricityNetworking.INSTANCE.sendToServer((Object)payload);
        return true;
    }
}

