/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.electricity.client.hooks;

import com.dooji.electricity.block.ElectricCabinBlockEntity;
import com.dooji.electricity.block.PowerBoxBlockEntity;
import com.dooji.electricity.block.UtilityPoleBlockEntity;
import com.dooji.electricity.block.WindTurbineBlockEntity;
import com.dooji.electricity.client.render.obj.ObjRaycaster;
import com.dooji.electricity.client.screen.PowerInfoScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class PowerWrenchClientHooks {
    private PowerWrenchClientHooks() {
    }

    public static InteractionResultHolder<ItemStack> handleUse(Level level, Player player, InteractionHand hand, double reach) {
        ItemStack stack = player.m_21120_(hand);
        if (PowerWrenchClientHooks.tryOpenDiagnostics(player, reach)) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public static InteractionResult handleUseOn(UseOnContext context, double reach) {
        Player player = context.m_43723_();
        if (player != null && PowerWrenchClientHooks.tryOpenDiagnostics(player, reach)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static boolean tryOpenDiagnostics(Player player, double reach) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return false;
        }
        BlockPos target = PowerWrenchClientHooks.findTargetedElectricBlock(mc, player, reach);
        if (target == null) {
            return false;
        }
        mc.m_91152_((Screen)new PowerInfoScreen(target));
        return true;
    }

    private static BlockPos findTargetedElectricBlock(Minecraft mc, Player player, double reach) {
        Vec3 eyePosition = player.m_20299_(1.0f);
        Vec3 lookDirection = player.m_20154_();
        BlockPos playerPos = player.m_20183_();
        int range = (int)Math.ceil(reach);
        double maxDistance = reach * reach;
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        BlockPos result = null;
        double bestDistance = Double.MAX_VALUE;
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    double distance;
                    Vec3 hitPoint;
                    BlockEntity blockEntity;
                    Vec3 centerEstimate;
                    cursor.m_122178_(playerPos.m_123341_() + x, playerPos.m_123342_() + y, playerPos.m_123343_() + z);
                    if (!mc.f_91073_.m_46805_((BlockPos)cursor) || eyePosition.m_82557_(centerEstimate = Vec3.m_82512_((Vec3i)cursor)) > maxDistance || !PowerWrenchClientHooks.isElectricBlock(blockEntity = mc.f_91073_.m_7702_((BlockPos)cursor)) || (hitPoint = ObjRaycaster.pickAnyGeometry(eyePosition, lookDirection, (BlockPos)cursor)) == null || !PowerWrenchClientHooks.hasLineOfSight(mc, player, eyePosition, hitPoint, (BlockPos)cursor) || !((distance = eyePosition.m_82557_(hitPoint)) < bestDistance)) continue;
                    bestDistance = distance;
                    result = cursor.m_7949_();
                }
            }
        }
        return result;
    }

    private static boolean hasLineOfSight(Minecraft mc, Player player, Vec3 start, Vec3 end, BlockPos targetPos) {
        if (mc.f_91073_ == null) {
            return false;
        }
        ClipContext context = new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
        BlockHitResult hitResult = mc.f_91073_.m_45547_(context);
        if (hitResult.m_6662_() == HitResult.Type.MISS) {
            return true;
        }
        return hitResult.m_82425_().equals((Object)targetPos);
    }

    private static boolean isElectricBlock(BlockEntity blockEntity) {
        return blockEntity instanceof WindTurbineBlockEntity || blockEntity instanceof ElectricCabinBlockEntity || blockEntity instanceof UtilityPoleBlockEntity || blockEntity instanceof PowerBoxBlockEntity;
    }
}

