/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.electricity.client.hooks;

import com.dooji.electricity.client.render.obj.ObjRaycaster;
import com.dooji.electricity.client.wire.WireAnchorHelper;
import com.dooji.electricity.client.wire.WireManagerClient;
import com.dooji.electricity.main.network.ElectricityNetworking;
import com.dooji.electricity.main.network.payloads.CreateWireFromInsulatorsPayload;
import com.dooji.electricity.wire.InsulatorPartHelper;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class WireClientHooks {
    private WireClientHooks() {
    }

    public static InteractionResult handleUseOn(UseOnContext context) {
        BlockPos clickedPos = context.m_8083_();
        Level level = context.m_43725_();
        BlockEntity blockEntity = level.m_7702_(clickedPos);
        if (blockEntity == null) {
            return InteractionResult.FAIL;
        }
        String hoveredPart = WireClientHooks.resolveHoveredPart(clickedPos);
        if (hoveredPart == null) {
            return InteractionResult.FAIL;
        }
        Vec3 connectionPoint = WireAnchorHelper.anchorOrFallback(blockEntity, hoveredPart, ObjRaycaster.getPartCenter(clickedPos, hoveredPart));
        if (connectionPoint == null) {
            return InteractionResult.FAIL;
        }
        Vec3 pendingPos = WireManagerClient.getPendingConnection();
        String pendingPart = WireManagerClient.getPendingPartName();
        if (pendingPos == null) {
            WireManagerClient.setPendingConnection(connectionPoint, clickedPos);
            WireManagerClient.setPendingPartName(hoveredPart);
            return InteractionResult.SUCCESS;
        }
        if (pendingPos.equals((Object)connectionPoint)) {
            WireManagerClient.clearPendingConnection();
            return InteractionResult.SUCCESS;
        }
        BlockPos pendingBlockPos = WireManagerClient.getPendingBlockPos();
        WireManagerClient.clearPendingConnection();
        return WireClientHooks.createWireFromInsulators(context, pendingBlockPos, clickedPos, pendingPart, hoveredPart);
    }

    private static InteractionResult createWireFromInsulators(UseOnContext context, BlockPos startBlockPos, BlockPos endBlockPos, String startPartName, String endPartName) {
        Level level = context.m_43725_();
        BlockEntity startEntity = level.m_7702_(startBlockPos);
        BlockEntity endEntity = level.m_7702_(endBlockPos);
        if (startEntity == null || endEntity == null) {
            return InteractionResult.FAIL;
        }
        Optional<InsulatorPartHelper.Insulator> start = InsulatorPartHelper.resolve(startEntity, startPartName);
        Optional<InsulatorPartHelper.Insulator> end = InsulatorPartHelper.resolve(endEntity, endPartName);
        if (start.isEmpty() || end.isEmpty()) {
            return InteractionResult.FAIL;
        }
        String startPower = InsulatorPartHelper.determinePowerType(startEntity, startPartName);
        String endPower = InsulatorPartHelper.determinePowerType(endEntity, endPartName);
        CreateWireFromInsulatorsPayload payload = new CreateWireFromInsulatorsPayload(start.get().insulatorId(), end.get().insulatorId(), startBlockPos, endBlockPos, start.get().blockType(), end.get().blockType(), startPower, endPower);
        ElectricityNetworking.INSTANCE.sendToServer((Object)payload);
        return InteractionResult.SUCCESS;
    }

    private static String resolveHoveredPart(BlockPos clickedPos) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return null;
        }
        Vec3 cameraPos = mc.f_91074_.m_146892_();
        Vec3 lookDirection = mc.f_91074_.m_20154_();
        return ObjRaycaster.getHoveredPart(cameraPos, lookDirection, clickedPos);
    }
}

