/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.electricity.client.render.block;

import com.dooji.electricity.block.ElectricCabinBlock;
import com.dooji.electricity.block.ElectricCabinBlockEntity;
import com.dooji.electricity.client.TrackedBlockEntities;
import com.dooji.electricity.client.render.obj.ObjBlockRegistry;
import com.dooji.electricity.client.render.obj.ObjBoundingBoxRegistry;
import com.dooji.electricity.client.render.obj.ObjInteractionRegistry;
import com.dooji.electricity.client.render.obj.ObjLoader;
import com.dooji.electricity.client.render.obj.ObjModel;
import com.dooji.electricity.client.render.obj.ObjRenderUtil;
import com.dooji.electricity.client.render.obj.ObjRenderer;
import com.dooji.electricity.main.Electricity;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="electricity", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ElectricCabinRenderer {
    private static final double MAX_RENDER_DISTANCE_SQ = 4096.0;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"electricity");

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        for (ElectricCabinBlockEntity cabin : TrackedBlockEntities.ofType(ElectricCabinBlockEntity.class)) {
            ObjRenderUtil.withAlignedPose(cabin, event.getPoseStack(), (MultiBufferSource)bufferSource, cameraPos, 4096.0, state -> (Direction)state.m_61143_((Property)ElectricCabinBlock.FACING), ElectricCabinRenderer::rotationForCabin, (context, pose, buffers) -> ObjRenderer.render(context.model(), pose, buffers, context.texture(), context.packedLight()));
        }
        bufferSource.m_109911_();
    }

    public static void init() {
        ResourceLocation modelLocation = ResourceLocation.fromNamespaceAndPath((String)"electricity", (String)"models/electric_cab/cab.obj");
        ObjBlockRegistry.register((Block)Electricity.ELECTRIC_CABIN_BLOCK.get(), modelLocation, null);
        ObjInteractionRegistry.register((Block)Electricity.ELECTRIC_CABIN_BLOCK.get(), "insulator_input_Material.065", null);
        ObjInteractionRegistry.register((Block)Electricity.ELECTRIC_CABIN_BLOCK.get(), "insulatoroutput_Material.044", null);
        ElectricCabinRenderer.calculateAndRegisterBoundingBoxes();
    }

    private static void calculateAndRegisterBoundingBoxes() {
        String[] insulatorGroups;
        ObjModel model = ObjLoader.getModel(ResourceLocation.fromNamespaceAndPath((String)"electricity", (String)"models/electric_cab/cab.obj"));
        if (model == null) {
            LOGGER.error("Failed to load Electric Cabin model");
            return;
        }
        HashMap<String, ObjModel.BoundingBox> insulatorBoxes = new HashMap<String, ObjModel.BoundingBox>();
        for (String groupName : insulatorGroups = new String[]{"insulator_input_Material.065", "insulatoroutput_Material.044"}) {
            ObjModel.BoundingBox bbox = model.getBoundingBox(groupName);
            if (bbox != null) {
                insulatorBoxes.put(groupName, bbox);
                continue;
            }
            LOGGER.warn("Missing Electric Cabin insulator group: {}", (Object)groupName);
        }
        ObjBoundingBoxRegistry.registerBoundingBoxes((Block)Electricity.ELECTRIC_CABIN_BLOCK.get(), insulatorBoxes);
    }

    private static float rotationForCabin(Direction facing) {
        return switch (facing) {
            case Direction.EAST -> 0.0f;
            case Direction.SOUTH -> 270.0f;
            case Direction.WEST -> 180.0f;
            default -> 90.0f;
        };
    }
}

