/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.electricity.client.render.block;

import com.dooji.electricity.block.UtilityPoleBlock;
import com.dooji.electricity.block.UtilityPoleBlockEntity;
import com.dooji.electricity.client.TrackedBlockEntities;
import com.dooji.electricity.client.render.obj.ObjBlockRegistry;
import com.dooji.electricity.client.render.obj.ObjBoundingBoxRegistry;
import com.dooji.electricity.client.render.obj.ObjInteractionRegistry;
import com.dooji.electricity.client.render.obj.ObjLoader;
import com.dooji.electricity.client.render.obj.ObjModel;
import com.dooji.electricity.client.render.obj.ObjRenderUtil;
import com.dooji.electricity.client.render.obj.ObjRenderer;
import com.dooji.electricity.main.Electricity;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="electricity", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class UtilityPoleRenderer {
    private static final double MAX_RENDER_DISTANCE_SQ = 4096.0;

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        for (UtilityPoleBlockEntity blockEntity : TrackedBlockEntities.ofType(UtilityPoleBlockEntity.class)) {
            ObjRenderUtil.withAlignedPose(blockEntity, event.getPoseStack(), (MultiBufferSource)bufferSource, cameraPos, 4096.0, state -> (Direction)state.m_61143_((Property)UtilityPoleBlock.FACING), UtilityPoleRenderer::rotationForPole, (context, pose, buffers) -> ObjRenderer.render(context.model(), pose, buffers, context.texture(), context.packedLight()));
        }
        bufferSource.m_109911_();
    }

    public static void init() {
        ResourceLocation modelLocation = ResourceLocation.fromNamespaceAndPath((String)"electricity", (String)"models/utility_pole/utility_pole.obj");
        ObjBlockRegistry.register((Block)Electricity.UTILITY_POLE_BLOCK.get(), modelLocation, null);
        ObjInteractionRegistry.register((Block)Electricity.UTILITY_POLE_BLOCK.get(), "insulator_1_Material.023", null);
        ObjInteractionRegistry.register((Block)Electricity.UTILITY_POLE_BLOCK.get(), "insulator_2_Material.009", null);
        ObjInteractionRegistry.register((Block)Electricity.UTILITY_POLE_BLOCK.get(), "insulator_3_Material.016", null);
        ObjInteractionRegistry.register((Block)Electricity.UTILITY_POLE_BLOCK.get(), "insulator_4_Material.001", null);
        ObjInteractionRegistry.register((Block)Electricity.UTILITY_POLE_BLOCK.get(), "insulator_5_Material.051", null);
        ObjInteractionRegistry.register((Block)Electricity.UTILITY_POLE_BLOCK.get(), "insulator_6_Material.037", null);
        ObjInteractionRegistry.register((Block)Electricity.UTILITY_POLE_BLOCK.get(), "insulator_7_Material.030", null);
        ObjInteractionRegistry.register((Block)Electricity.UTILITY_POLE_BLOCK.get(), "insulator_8_Material.058", null);
        UtilityPoleRenderer.calculateAndRegisterBoundingBoxes();
    }

    private static void calculateAndRegisterBoundingBoxes() {
        String[] insulatorGroups;
        ObjModel model = ObjLoader.getModel(ResourceLocation.fromNamespaceAndPath((String)"electricity", (String)"models/utility_pole/utility_pole.obj"));
        if (model == null) {
            return;
        }
        HashMap<String, ObjModel.BoundingBox> insulatorBoxes = new HashMap<String, ObjModel.BoundingBox>();
        for (String groupName : insulatorGroups = new String[]{"insulator_1_Material.023", "insulator_2_Material.009", "insulator_3_Material.016", "insulator_4_Material.001", "insulator_5_Material.051", "insulator_6_Material.037", "insulator_7_Material.030", "insulator_8_Material.058"}) {
            ObjModel.BoundingBox bbox = model.getBoundingBox(groupName);
            if (bbox == null) continue;
            insulatorBoxes.put(groupName, bbox);
        }
        ObjBoundingBoxRegistry.registerBoundingBoxes((Block)Electricity.UTILITY_POLE_BLOCK.get(), insulatorBoxes);
    }

    private static float rotationForPole(Direction facing) {
        return switch (facing) {
            case Direction.EAST -> 180.0f;
            case Direction.SOUTH -> 270.0f;
            case Direction.WEST -> 0.0f;
            default -> 90.0f;
        };
    }
}

