/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.electricity.client.render.block;

import com.dooji.electricity.block.WindTurbineBlock;
import com.dooji.electricity.block.WindTurbineBlockEntity;
import com.dooji.electricity.client.TrackedBlockEntities;
import com.dooji.electricity.client.render.obj.ObjBlockRegistry;
import com.dooji.electricity.client.render.obj.ObjBoundingBoxRegistry;
import com.dooji.electricity.client.render.obj.ObjInteractionRegistry;
import com.dooji.electricity.client.render.obj.ObjLoader;
import com.dooji.electricity.client.render.obj.ObjModel;
import com.dooji.electricity.client.render.obj.ObjRenderUtil;
import com.dooji.electricity.client.render.obj.ObjRenderer;
import com.dooji.electricity.main.Electricity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Vector3f;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="electricity", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class WindTurbineRenderer {
    private static final double MAX_RENDER_DISTANCE_SQ = 16384.0;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"electricity");

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        for (WindTurbineBlockEntity turbine : TrackedBlockEntities.ofType(WindTurbineBlockEntity.class)) {
            ObjRenderUtil.withAlignedPose(turbine, event.getPoseStack(), (MultiBufferSource)bufferSource, cameraPos, 16384.0, state -> (Direction)state.m_61143_((Property)WindTurbineBlock.FACING), WindTurbineRenderer::rotationForTurbine, (context, pose, buffers) -> WindTurbineRenderer.renderWindTurbineWithAnimation(context.model(), pose, buffers, context.texture(), context.packedLight(), turbine));
        }
        bufferSource.m_109911_();
    }

    private static void renderWindTurbineWithAnimation(ObjModel model, PoseStack poseStack, MultiBufferSource bufferSource, ResourceLocation textureLocation, int packedLight, WindTurbineBlockEntity blockEntity) {
        float rotation1 = blockEntity.getRotation1();
        float rotation2 = blockEntity.getRotation2();
        Vec3 hubCenter = null;
        for (Map.Entry<String, ObjModel.ObjGroup> entry : model.groups.entrySet()) {
            if (!entry.getKey().equals("rotate_2_Plastic")) continue;
            hubCenter = WindTurbineRenderer.calculateGroupCenter(entry.getValue());
            break;
        }
        if (hubCenter == null) {
            hubCenter = new Vec3(0.0, 12.65, 0.95);
        }
        for (Map.Entry<String, ObjModel.ObjGroup> entry : model.groups.entrySet()) {
            String groupName = entry.getKey();
            ObjModel.ObjGroup group = entry.getValue();
            poseStack.m_85836_();
            if (groupName.equals("rotate_1_Plastic")) {
                poseStack.m_85837_(hubCenter.f_82479_, hubCenter.f_82480_, hubCenter.f_82481_);
                poseStack.m_252781_(Axis.f_252403_.m_252977_(rotation1));
                poseStack.m_85837_(-hubCenter.f_82479_, -hubCenter.f_82480_, -hubCenter.f_82481_);
            } else if (groupName.equals("rotate_2_Plastic")) {
                poseStack.m_85837_(hubCenter.f_82479_, hubCenter.f_82480_, hubCenter.f_82481_);
                poseStack.m_252781_(Axis.f_252403_.m_252977_(rotation2));
                poseStack.m_85837_(-hubCenter.f_82479_, -hubCenter.f_82480_, -hubCenter.f_82481_);
            }
            ObjRenderer.renderGroup(group, poseStack, bufferSource, model, textureLocation, packedLight);
            poseStack.m_85849_();
        }
    }

    private static Vec3 calculateGroupCenter(ObjModel.ObjGroup group) {
        if (group.vertices.isEmpty()) {
            return Vec3.f_82478_;
        }
        double minX = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double minY = Double.MAX_VALUE;
        double maxY = Double.MIN_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxZ = Double.MIN_VALUE;
        for (Vector3f vertex : group.vertices) {
            minX = Math.min(minX, (double)vertex.x);
            maxX = Math.max(maxX, (double)vertex.x);
            minY = Math.min(minY, (double)vertex.y);
            maxY = Math.max(maxY, (double)vertex.y);
            minZ = Math.min(minZ, (double)vertex.z);
            maxZ = Math.max(maxZ, (double)vertex.z);
        }
        return new Vec3((minX + maxX) / 2.0, (minY + maxY) / 2.0, (minZ + maxZ) / 2.0);
    }

    public static void init() {
        ResourceLocation modelLocation = ResourceLocation.fromNamespaceAndPath((String)"electricity", (String)"models/wind_turbine/wind_turbine.obj");
        ObjBlockRegistry.register((Block)Electricity.WIND_TURBINE_BLOCK.get(), modelLocation, null);
        ObjInteractionRegistry.register((Block)Electricity.WIND_TURBINE_BLOCK.get(), "insulator_Plastic", null);
        WindTurbineRenderer.calculateAndRegisterBoundingBoxes();
    }

    private static void calculateAndRegisterBoundingBoxes() {
        String[] insulatorGroups;
        ObjModel model = ObjLoader.getModel(ResourceLocation.fromNamespaceAndPath((String)"electricity", (String)"models/wind_turbine/wind_turbine.obj"));
        if (model == null) {
            LOGGER.error("Failed to load Wind Turbine model");
            return;
        }
        HashMap<String, ObjModel.BoundingBox> insulatorBoxes = new HashMap<String, ObjModel.BoundingBox>();
        for (String groupName : insulatorGroups = new String[]{"insulator_Plastic"}) {
            ObjModel.BoundingBox bbox = model.getBoundingBox(groupName);
            if (bbox != null) {
                insulatorBoxes.put(groupName, bbox);
                continue;
            }
            LOGGER.warn("Missing Wind Turbine insulator group: {}", (Object)groupName);
        }
        ObjBoundingBoxRegistry.registerBoundingBoxes((Block)Electricity.WIND_TURBINE_BLOCK.get(), insulatorBoxes);
    }

    private static float rotationForTurbine(Direction facing) {
        return switch (facing) {
            case Direction.EAST -> 90.0f;
            case Direction.SOUTH -> 0.0f;
            case Direction.WEST -> 270.0f;
            default -> 180.0f;
        };
    }
}

