/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.electricity.client.render.obj;

import com.dooji.electricity.client.render.obj.ObjInteractionHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ObjInteractionRegistry {
    private static final Map<Block, InteractionData> DATA = new HashMap<Block, InteractionData>();

    public static void register(Block block, String partName, ObjInteractionHandler handler) {
        InteractionData data = DATA.computeIfAbsent(block, key -> new InteractionData(new HashMap<String, ObjInteractionHandler>(), new HashSet<String>()));
        if (handler != null) {
            data.handlers().put(partName, handler);
        }
        data.parts().add(partName);
    }

    public static ObjInteractionHandler getHandler(Block block, String partName) {
        InteractionData data = DATA.get(block);
        return data != null ? data.handlers().get(partName) : null;
    }

    public static Set<String> getInteractiveParts(Block block) {
        InteractionData data = DATA.get(block);
        return data != null ? Collections.unmodifiableSet(data.parts()) : Collections.emptySet();
    }

    public static boolean isInteractivePart(Block block, String partName) {
        InteractionData data = DATA.get(block);
        return data != null && data.parts().contains(partName);
    }

    private record InteractionData(Map<String, ObjInteractionHandler> handlers, Set<String> parts) {
    }
}

