/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.electricity.client.render.obj;

import com.dooji.electricity.client.render.obj.ObjModel;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ObjLoader {
    private static final Map<ResourceLocation, ObjModel> loadedModels = new HashMap<ResourceLocation, ObjModel>();

    public static ObjModel getModel(ResourceLocation location) {
        ObjModel model = loadedModels.get(location);
        if (model == null && (model = ObjModel.loadFromResource(location)) != null) {
            loadedModels.put(location, model);
        }
        return model;
    }

    public static void unloadModel(ResourceLocation location) {
        loadedModels.remove(location);
    }

    public static void clearCache() {
        loadedModels.clear();
    }
}

