/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.electricity.client.render.obj;

import com.dooji.electricity.block.ElectricCabinBlock;
import com.dooji.electricity.block.ElectricCabinBlockEntity;
import com.dooji.electricity.block.PowerBoxBlock;
import com.dooji.electricity.block.PowerBoxBlockEntity;
import com.dooji.electricity.block.UtilityPoleBlock;
import com.dooji.electricity.block.UtilityPoleBlockEntity;
import com.dooji.electricity.block.WindTurbineBlockEntity;
import com.dooji.electricity.client.render.obj.ObjBlockRegistry;
import com.dooji.electricity.client.render.obj.ObjBoundingBoxRegistry;
import com.dooji.electricity.client.render.obj.ObjInteractionRegistry;
import com.dooji.electricity.client.render.obj.ObjLoader;
import com.dooji.electricity.client.render.obj.ObjModel;
import com.dooji.electricity.client.render.obj.ObjTransforms;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class ObjRaycaster {
    public static boolean isHoveringPart(Vec3 rayOrigin, Vec3 rayDirection, BlockPos blockPos, String partName) {
        return ObjRaycaster.isHoveringPart(rayOrigin, rayDirection, blockPos, partName, null);
    }

    public static boolean isHoveringPart(Vec3 rayOrigin, Vec3 rayDirection, BlockPos blockPos, String partName, Direction facing) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return false;
        }
        BlockState blockState = mc.f_91073_.m_8055_(blockPos);
        ResourceLocation modelLocation = ObjBlockRegistry.getModelLocation(blockState.m_60734_());
        if (modelLocation == null) {
            return false;
        }
        ObjModel model = ObjLoader.getModel(modelLocation);
        if (model == null) {
            return false;
        }
        ObjRaycaster.ensureBoundingBoxes(blockState.m_60734_(), model);
        ObjModel.BoundingBox partBox = ObjBoundingBoxRegistry.getBoundingBox(blockState.m_60734_(), partName);
        if (partBox == null) {
            return false;
        }
        ObjTransforms.Transform transform = ObjTransforms.resolve(mc.f_91073_.m_7702_(blockPos));
        Direction effectiveFacing = facing != null ? facing : ObjRaycaster.getFacing(blockState);
        WorldBounds bounds = ObjRaycaster.buildWorldBounds(partBox, blockPos, blockState, effectiveFacing, transform);
        return ObjRaycaster.rayIntersectsBox(rayOrigin, rayDirection, bounds.min(), bounds.max());
    }

    public static String getHoveredPart(Vec3 rayOrigin, Vec3 rayDirection, BlockPos blockPos) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return null;
        }
        BlockState blockState = mc.f_91073_.m_8055_(blockPos);
        ResourceLocation modelLocation = ObjBlockRegistry.getModelLocation(blockState.m_60734_());
        if (modelLocation == null) {
            return null;
        }
        ObjModel model = ObjLoader.getModel(modelLocation);
        if (model == null) {
            return null;
        }
        Direction facing = ObjRaycaster.getFacing(blockState);
        ObjRaycaster.ensureBoundingBoxes(blockState.m_60734_(), model);
        Set<String> interactiveParts = ObjInteractionRegistry.getInteractiveParts(blockState.m_60734_());
        for (String partName : interactiveParts) {
            if (ObjBoundingBoxRegistry.getBoundingBox(blockState.m_60734_(), partName) == null || !ObjRaycaster.isHoveringPart(rayOrigin, rayDirection, blockPos, partName, facing)) continue;
            return partName;
        }
        Map<String, ObjModel.BoundingBox> boundingBoxes = ObjBoundingBoxRegistry.getAllBoundingBoxes(blockState.m_60734_());
        if (boundingBoxes != null && !boundingBoxes.isEmpty()) {
            for (String partName : boundingBoxes.keySet()) {
                if (!ObjRaycaster.isHoveringPart(rayOrigin, rayDirection, blockPos, partName, facing)) continue;
                return partName;
            }
        }
        return null;
    }

    public static Vec3 getPartCenter(BlockPos blockPos, String partName) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return null;
        }
        BlockState blockState = mc.f_91073_.m_8055_(blockPos);
        Direction facing = ObjRaycaster.getFacing(blockState);
        return ObjRaycaster.getPartCenter(blockPos, partName, facing);
    }

    public static Vec3 getPartCenter(BlockPos blockPos, String partName, Direction facing) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return null;
        }
        BlockState blockState = mc.f_91073_.m_8055_(blockPos);
        ResourceLocation modelLocation = ObjBlockRegistry.getModelLocation(blockState.m_60734_());
        if (modelLocation == null) {
            return null;
        }
        ObjModel model = ObjLoader.getModel(modelLocation);
        if (model == null) {
            return null;
        }
        ObjRaycaster.ensureBoundingBoxes(blockState.m_60734_(), model);
        ObjModel.BoundingBox partBox = ObjBoundingBoxRegistry.getBoundingBox(blockState.m_60734_(), partName);
        if (partBox == null) {
            return null;
        }
        ObjTransforms.Transform transform = ObjTransforms.resolve(mc.f_91073_.m_7702_(blockPos));
        Direction effectiveFacing = facing != null ? facing : ObjRaycaster.getFacing(blockState);
        return ObjRaycaster.buildWorldCenter(partBox, blockPos, blockState, effectiveFacing, transform);
    }

    public static Vec3 rotatePointAroundCenter(Vec3 point, Vec3 center, Direction facing, BlockState blockState) {
        Vec3 relative = point.m_82546_(center);
        double rotatedX = relative.f_82479_;
        double rotatedZ = relative.f_82481_;
        if (blockState.m_60734_() instanceof ElectricCabinBlock || blockState.m_60734_() instanceof PowerBoxBlock) {
            switch (facing) {
                case EAST: {
                    rotatedX = relative.f_82479_;
                    rotatedZ = relative.f_82481_;
                    break;
                }
                case SOUTH: {
                    rotatedX = -relative.f_82481_;
                    rotatedZ = relative.f_82479_;
                    break;
                }
                case WEST: {
                    rotatedX = -relative.f_82479_;
                    rotatedZ = -relative.f_82481_;
                    break;
                }
                default: {
                    rotatedX = relative.f_82481_;
                    rotatedZ = -relative.f_82479_;
                    break;
                }
            }
        } else {
            switch (facing) {
                case EAST: {
                    rotatedX = -relative.f_82479_;
                    rotatedZ = -relative.f_82481_;
                    break;
                }
                case SOUTH: {
                    rotatedX = -relative.f_82481_;
                    rotatedZ = relative.f_82479_;
                    break;
                }
                case WEST: {
                    rotatedX = relative.f_82479_;
                    rotatedZ = relative.f_82481_;
                    break;
                }
                default: {
                    rotatedX = relative.f_82481_;
                    rotatedZ = -relative.f_82479_;
                }
            }
        }
        return new Vec3(center.f_82479_ + rotatedX, center.f_82480_ + relative.f_82480_, center.f_82481_ + rotatedZ);
    }

    public static Vec3 applyYawPitchRotation(Vec3 point, Vec3 center, float yaw, float pitch) {
        double z;
        Vec3 relative = point.m_82546_(center);
        if (pitch != 0.0f) {
            double cosPitch = Math.cos(Math.toRadians(pitch));
            double sinPitch = Math.sin(Math.toRadians(pitch));
            double y = relative.f_82480_ * cosPitch - relative.f_82481_ * sinPitch;
            z = relative.f_82480_ * sinPitch + relative.f_82481_ * cosPitch;
            relative = new Vec3(relative.f_82479_, y, z);
        }
        if (yaw != 0.0f) {
            double cosYaw = Math.cos(Math.toRadians(yaw));
            double sinYaw = Math.sin(Math.toRadians(yaw));
            double x = relative.f_82479_ * cosYaw + relative.f_82481_ * sinYaw;
            z = -relative.f_82479_ * sinYaw + relative.f_82481_ * cosYaw;
            relative = new Vec3(x, relative.f_82480_, z);
        }
        return center.m_82549_(relative);
    }

    public static boolean rayIntersectsBox(Vec3 rayOrigin, Vec3 rayDirection, Vec3 boxMin, Vec3 boxMax) {
        double tMin = Double.NEGATIVE_INFINITY;
        double tMax = Double.POSITIVE_INFINITY;
        if (rayDirection.f_82479_ != 0.0) {
            double tx1 = (boxMin.f_82479_ - rayOrigin.f_82479_) / rayDirection.f_82479_;
            double tx2 = (boxMax.f_82479_ - rayOrigin.f_82479_) / rayDirection.f_82479_;
            tMin = Math.max(tMin, Math.min(tx1, tx2));
            tMax = Math.min(tMax, Math.max(tx1, tx2));
        } else if (rayOrigin.f_82479_ < boxMin.f_82479_ || rayOrigin.f_82479_ > boxMax.f_82479_) {
            return false;
        }
        if (rayDirection.f_82480_ != 0.0) {
            double ty1 = (boxMin.f_82480_ - rayOrigin.f_82480_) / rayDirection.f_82480_;
            double ty2 = (boxMax.f_82480_ - rayOrigin.f_82480_) / rayDirection.f_82480_;
            tMin = Math.max(tMin, Math.min(ty1, ty2));
            tMax = Math.min(tMax, Math.max(ty1, ty2));
        } else if (rayOrigin.f_82480_ < boxMin.f_82480_ || rayOrigin.f_82480_ > boxMax.f_82480_) {
            return false;
        }
        if (rayDirection.f_82481_ != 0.0) {
            double tz1 = (boxMin.f_82481_ - rayOrigin.f_82481_) / rayDirection.f_82481_;
            double tz2 = (boxMax.f_82481_ - rayOrigin.f_82481_) / rayDirection.f_82481_;
            tMin = Math.max(tMin, Math.min(tz1, tz2));
            tMax = Math.min(tMax, Math.max(tz1, tz2));
        } else if (rayOrigin.f_82481_ < boxMin.f_82481_ || rayOrigin.f_82481_ > boxMax.f_82481_) {
            return false;
        }
        return tMax >= tMin && tMax >= 0.0;
    }

    public static List<Component> getPowerDisplayText(BlockPos blockPos) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return null;
        }
        return ObjRaycaster.getPowerDisplayText(mc.f_91073_.m_7702_(blockPos));
    }

    public static List<Component> getPowerDisplayText(BlockEntity blockEntity) {
        if (blockEntity instanceof WindTurbineBlockEntity) {
            WindTurbineBlockEntity turbine = (WindTurbineBlockEntity)blockEntity;
            return List.of(blockEntity.m_58900_().m_60734_().m_49954_(), Component.m_237110_((String)"tooltip.electricity.power.generated", (Object[])new Object[]{ObjRaycaster.formatPower(turbine.getGeneratedPower())}), Component.m_237110_((String)"tooltip.electricity.power.current", (Object[])new Object[]{ObjRaycaster.formatPower(turbine.getCurrentPower())}));
        }
        if (blockEntity instanceof ElectricCabinBlockEntity) {
            ElectricCabinBlockEntity cabin = (ElectricCabinBlockEntity)blockEntity;
            return List.of(blockEntity.m_58900_().m_60734_().m_49954_(), Component.m_237110_((String)"tooltip.electricity.power.amount", (Object[])new Object[]{ObjRaycaster.formatPower(cabin.getCurrentPower())}));
        }
        if (blockEntity instanceof UtilityPoleBlockEntity) {
            UtilityPoleBlockEntity pole = (UtilityPoleBlockEntity)blockEntity;
            return List.of(blockEntity.m_58900_().m_60734_().m_49954_(), Component.m_237110_((String)"tooltip.electricity.power.amount", (Object[])new Object[]{ObjRaycaster.formatPower(pole.getCurrentPower())}));
        }
        if (blockEntity instanceof PowerBoxBlockEntity) {
            PowerBoxBlockEntity powerBox = (PowerBoxBlockEntity)blockEntity;
            return List.of(blockEntity.m_58900_().m_60734_().m_49954_(), Component.m_237110_((String)"tooltip.electricity.power.amount", (Object[])new Object[]{ObjRaycaster.formatPower(powerBox.getCurrentPower())}));
        }
        return null;
    }

    public static Vec3 pickAnyGeometry(Vec3 rayOrigin, Vec3 rayDirection, BlockPos blockPos) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return null;
        }
        BlockState blockState = mc.f_91073_.m_8055_(blockPos);
        ResourceLocation modelLocation = ObjBlockRegistry.getModelLocation(blockState.m_60734_());
        if (modelLocation == null) {
            return null;
        }
        ObjModel model = ObjLoader.getModel(modelLocation);
        if (model == null) {
            return null;
        }
        Direction facing = ObjRaycaster.getFacing(blockState);
        ObjRaycaster.ensureBoundingBoxes(blockState.m_60734_(), model);
        ObjTransforms.Transform transform = ObjTransforms.resolve(mc.f_91073_.m_7702_(blockPos));
        Vec3 bestCenter = null;
        double bestDistance = Double.MAX_VALUE;
        Map<String, ObjModel.BoundingBox> boxes = model.getAllBoundingBoxes();
        for (Map.Entry<String, ObjModel.BoundingBox> entry : boxes.entrySet()) {
            Vec3 center;
            double distance;
            WorldBounds bounds;
            ObjModel.BoundingBox box = entry.getValue();
            if (box == null || !ObjRaycaster.rayIntersectsBox(rayOrigin, rayDirection, (bounds = ObjRaycaster.buildWorldBounds(box, blockPos, blockState, facing, transform)).min(), bounds.max()) || !((distance = rayOrigin.m_82557_(center = ObjRaycaster.buildWorldCenter(box, blockPos, blockState, facing, transform))) < bestDistance)) continue;
            bestDistance = distance;
            bestCenter = center;
        }
        return bestCenter;
    }

    private static Direction getFacing(BlockState blockState) {
        if (blockState.m_61138_((Property)UtilityPoleBlock.FACING)) {
            return (Direction)blockState.m_61143_((Property)UtilityPoleBlock.FACING);
        }
        if (blockState.m_61138_((Property)ElectricCabinBlock.FACING)) {
            return (Direction)blockState.m_61143_((Property)ElectricCabinBlock.FACING);
        }
        if (blockState.m_61138_((Property)PowerBoxBlock.FACING)) {
            return (Direction)blockState.m_61143_((Property)PowerBoxBlock.FACING);
        }
        return null;
    }

    private static void ensureBoundingBoxes(Block block, ObjModel model) {
        Map<String, ObjModel.BoundingBox> boxes;
        if (ObjBoundingBoxRegistry.getAllBoundingBoxes(block).isEmpty() && !(boxes = model.getAllBoundingBoxes()).isEmpty()) {
            ObjBoundingBoxRegistry.registerBoundingBoxes(block, boxes);
        }
    }

    private static WorldBounds buildWorldBounds(ObjModel.BoundingBox box, BlockPos blockPos, BlockState state, Direction facing, ObjTransforms.Transform transform) {
        Vec3 blockOffset = Vec3.m_82528_((Vec3i)blockPos).m_82520_(0.5, 0.0, 0.5);
        Vec3 min = ObjRaycaster.toVec3(box.min).m_82549_(blockOffset);
        Vec3 max = ObjRaycaster.toVec3(box.max).m_82549_(blockOffset);
        Vec3 center = new Vec3((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5);
        if (facing != null) {
            min = ObjRaycaster.rotatePointAroundCenter(min, center, facing, state);
            max = ObjRaycaster.rotatePointAroundCenter(max, center, facing, state);
        }
        min = min.m_82520_((double)transform.offsetX(), (double)transform.offsetY(), (double)transform.offsetZ());
        max = max.m_82520_((double)transform.offsetX(), (double)transform.offsetY(), (double)transform.offsetZ());
        if (transform.yaw() != 0.0f || transform.pitch() != 0.0f) {
            min = ObjRaycaster.applyYawPitchRotation(min, center, transform.yaw(), transform.pitch());
            max = ObjRaycaster.applyYawPitchRotation(max, center, transform.yaw(), transform.pitch());
        }
        return new WorldBounds(min, max);
    }

    private static Vec3 buildWorldCenter(ObjModel.BoundingBox box, BlockPos blockPos, BlockState state, Direction facing, ObjTransforms.Transform transform) {
        Vec3 center = ObjRaycaster.toVec3(box.center).m_82549_(Vec3.m_82528_((Vec3i)blockPos)).m_82520_(0.5, 0.0, 0.5);
        Vec3 blockCenter = new Vec3((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5);
        if (facing != null) {
            center = ObjRaycaster.rotatePointAroundCenter(center, blockCenter, facing, state);
        }
        center = center.m_82520_((double)transform.offsetX(), (double)transform.offsetY(), (double)transform.offsetZ());
        if (transform.yaw() != 0.0f || transform.pitch() != 0.0f) {
            center = ObjRaycaster.applyYawPitchRotation(center, blockCenter, transform.yaw(), transform.pitch());
        }
        return center;
    }

    private static Vec3 toVec3(Vector3f vector) {
        return new Vec3((double)vector.x, (double)vector.y, (double)vector.z);
    }

    private static String formatPower(double power) {
        return String.format(Locale.ROOT, "%.1f", power);
    }

    private record WorldBounds(Vec3 min, Vec3 max) {
    }
}

