/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.electricity.client.render.obj;

import com.dooji.electricity.client.render.obj.FacingRotationFunction;
import com.dooji.electricity.client.render.obj.ObjBlockRegistry;
import com.dooji.electricity.client.render.obj.ObjLoader;
import com.dooji.electricity.client.render.obj.ObjModel;
import com.dooji.electricity.client.render.obj.ObjRenderAction;
import com.dooji.electricity.client.render.obj.ObjRenderContext;
import com.dooji.electricity.client.render.obj.ObjTransforms;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.function.Function;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class ObjRenderUtil {
    private ObjRenderUtil() {
    }

    public static boolean withAlignedPose(BlockEntity entity, PoseStack poseStack, MultiBufferSource bufferSource, Vec3 cameraPos, double maxDistanceSq, Function<BlockState, Direction> facingExtractor, FacingRotationFunction rotationFunction, ObjRenderAction action) {
        if (entity == null || action == null) {
            return false;
        }
        Level level = entity.m_58904_();
        if (level == null) {
            return false;
        }
        BlockPos pos = entity.m_58899_();
        if (cameraPos.m_82531_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) > maxDistanceSq) {
            return false;
        }
        BlockState blockState = entity.m_58900_();
        Block block = blockState.m_60734_();
        if (!ObjBlockRegistry.hasModel(block)) {
            return false;
        }
        ResourceLocation modelLocation = ObjBlockRegistry.getModelLocation(block);
        ObjModel model = ObjLoader.getModel(modelLocation);
        if (model == null) {
            return false;
        }
        ResourceLocation texture = ObjBlockRegistry.getTextureLocation(block);
        Direction facing = facingExtractor != null ? facingExtractor.apply(blockState) : null;
        float facingRotation = facing != null && rotationFunction != null ? rotationFunction.rotation(facing) : 0.0f;
        ObjTransforms.Transform transform = ObjTransforms.resolve(entity);
        int packedLight = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)pos);
        Vec3 viewPos = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_82546_(cameraPos);
        poseStack.m_85836_();
        poseStack.m_85837_(viewPos.f_82479_, viewPos.f_82480_, viewPos.f_82481_);
        poseStack.m_85837_(0.5, 0.0, 0.5);
        if (facingRotation != 0.0f) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(facingRotation));
        }
        poseStack.m_252880_(transform.offsetX(), transform.offsetY(), transform.offsetZ());
        if (transform.yaw() != 0.0f) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(transform.yaw()));
        }
        if (transform.pitch() != 0.0f) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(transform.pitch()));
        }
        action.render(new ObjRenderContext(model, texture, packedLight), poseStack, bufferSource);
        poseStack.m_85849_();
        return true;
    }
}

