/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.electricity.client.render.obj;

import com.dooji.electricity.client.render.obj.ObjModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT)
public class ObjRenderer {
    public static void render(ObjModel model, PoseStack poseStack, MultiBufferSource bufferSource, ResourceLocation texturePrefix, int packedLight) {
        if (model == null) {
            return;
        }
        for (ObjModel.ObjGroup group : model.groups.values()) {
            ObjRenderer.renderGroup(group, poseStack, bufferSource, model, texturePrefix, packedLight);
        }
    }

    public static void renderGroup(ObjModel.ObjGroup group, PoseStack poseStack, MultiBufferSource bufferSource, ObjModel model, ResourceLocation texturePrefix, int packedLight) {
        ObjModel.ObjMaterial material = model.materials.get(group.materialName);
        VertexConsumer vertexBuffer = material != null && material.texture != null ? bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)material.texture)) : bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)texturePrefix));
        ObjRenderer.renderMeshWithColor(group, vertexBuffer, poseStack, packedLight);
    }

    private static void renderMeshWithColor(ObjModel.ObjGroup group, VertexConsumer consumer, PoseStack poseStack, int packedLight) {
        List<Vector3f> vertices = group.vertices;
        List<Vector3f> normals = group.normals;
        List<Float> uvs = group.texCoords;
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f matrix = pose.m_252922_();
        Matrix3f normalMatrix = pose.m_252943_();
        for (int i = 0; i < vertices.size(); ++i) {
            Vector3f pos = vertices.get(i);
            Vector3f normal = normals.get(i);
            float u = uvs.get(i * 2).floatValue();
            float v = uvs.get(i * 2 + 1).floatValue();
            Vector3f transformedNormal = new Vector3f((Vector3fc)normal);
            normalMatrix.transform(transformedNormal);
            transformedNormal.normalize().mul(-1.0f);
            consumer.m_252986_(matrix, pos.x, pos.y, pos.z).m_6122_(255, 255, 255, 255).m_7421_(u, v).m_7122_(0, 10).m_85969_(packedLight).m_5601_(transformedNormal.x, transformedNormal.y, transformedNormal.z).m_5752_();
        }
    }
}

