/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.electricity.client.screen;

import com.dooji.electricity.block.UtilityPoleBlockEntity;
import com.dooji.electricity.block.WindTurbineBlockEntity;
import com.dooji.electricity.client.render.obj.ObjRaycaster;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PowerInfoScreen
extends Screen {
    private final BlockPos targetPos;

    public PowerInfoScreen(BlockPos targetPos) {
        super((Component)Component.m_237115_((String)"screen.electricity.power_info.title"));
        this.targetPos = targetPos.m_7949_();
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.f_96541_ == null || this.f_96541_.f_91073_ == null || this.f_96541_.f_91073_.m_7702_(this.targetPos) == null) {
            this.m_7379_();
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        Font font = this.f_96547_;
        int centerX = this.f_96543_ / 2;
        int y = this.f_96544_ / 4;
        guiGraphics.m_280653_(font, this.f_96539_, centerX, y, 0xFFFFFF);
        Objects.requireNonNull(font);
        y += 9 + 8;
        for (Component line : this.collectInfoLines()) {
            guiGraphics.m_280653_(font, line, centerX, y, 0xC6C6C6);
            Objects.requireNonNull(font);
            y += 9 + 2;
        }
    }

    private List<Component> collectInfoLines() {
        ArrayList<Component> lines = new ArrayList<Component>();
        if (this.f_96541_ == null || this.f_96541_.f_91073_ == null) {
            lines.add((Component)Component.m_237115_((String)"screen.electricity.power_info.world_unavailable"));
            return lines;
        }
        BlockEntity blockEntity = this.f_96541_.f_91073_.m_7702_(this.targetPos);
        if (blockEntity == null) {
            lines.add((Component)Component.m_237115_((String)"screen.electricity.power_info.block_removed"));
            return lines;
        }
        List<Component> powerLines = ObjRaycaster.getPowerDisplayText(blockEntity);
        if (powerLines != null) {
            lines.addAll(powerLines);
        } else {
            lines.add((Component)blockEntity.m_58900_().m_60734_().m_49954_());
            lines.add((Component)Component.m_237115_((String)"screen.electricity.power_info.no_power_data"));
        }
        if (blockEntity instanceof WindTurbineBlockEntity) {
            WindTurbineBlockEntity turbine = (WindTurbineBlockEntity)blockEntity;
            lines.add((Component)Component.m_237110_((String)"screen.electricity.power_info.wind_speed", (Object[])new Object[]{PowerInfoScreen.formatNumber("%.1f", Float.valueOf(turbine.getWindSpeed()))}));
            lines.add((Component)Component.m_237110_((String)"screen.electricity.power_info.rotation", (Object[])new Object[]{PowerInfoScreen.formatNumber("%.1f", Float.valueOf(turbine.getRotation1())), PowerInfoScreen.formatNumber("%.1f", Float.valueOf(turbine.getRotation2()))}));
        } else if (blockEntity instanceof UtilityPoleBlockEntity) {
            UtilityPoleBlockEntity pole = (UtilityPoleBlockEntity)blockEntity;
            lines.add((Component)Component.m_237110_((String)"screen.electricity.power_info.offsets", (Object[])new Object[]{PowerInfoScreen.formatNumber("%.2f", Float.valueOf(pole.getOffsetX())), PowerInfoScreen.formatNumber("%.2f", Float.valueOf(pole.getOffsetY())), PowerInfoScreen.formatNumber("%.2f", Float.valueOf(pole.getOffsetZ()))}));
            lines.add((Component)Component.m_237110_((String)"screen.electricity.power_info.yaw_pitch", (Object[])new Object[]{PowerInfoScreen.formatNumber("%.1f", Math.toDegrees(pole.getYaw())), PowerInfoScreen.formatNumber("%.1f", Math.toDegrees(pole.getPitch()))}));
        }
        return lines;
    }

    private static String formatNumber(String pattern, Object ... values) {
        return String.format(Locale.ROOT, pattern, values);
    }

    public boolean m_7043_() {
        return false;
    }
}

