/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.electricity.client.wire;

import com.dooji.electricity.block.ElectricCabinBlockEntity;
import com.dooji.electricity.block.PowerBoxBlockEntity;
import com.dooji.electricity.block.UtilityPoleBlockEntity;
import com.dooji.electricity.block.WindTurbineBlockEntity;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class InsulatorLookup {
    private static final Map<Integer, WeakReference<BlockEntity>> REGISTRY = new ConcurrentHashMap<Integer, WeakReference<BlockEntity>>();

    private InsulatorLookup() {
    }

    public static void register(BlockEntity blockEntity) {
        if (blockEntity == null) {
            return;
        }
        int[] insulatorIds = InsulatorLookup.extractIds(blockEntity);
        InsulatorLookup.register(blockEntity, insulatorIds);
    }

    public static void register(BlockEntity blockEntity, int[] insulatorIds) {
        if (blockEntity == null || insulatorIds == null) {
            return;
        }
        for (int id : insulatorIds) {
            if (id < 0) continue;
            REGISTRY.put(id, new WeakReference<BlockEntity>(blockEntity));
        }
    }

    public static void unregister(int[] insulatorIds) {
        if (insulatorIds == null) {
            return;
        }
        for (int id : insulatorIds) {
            REGISTRY.remove(id);
        }
    }

    public static BlockEntity get(int insulatorId) {
        WeakReference<BlockEntity> reference = REGISTRY.get(insulatorId);
        if (reference == null) {
            return null;
        }
        BlockEntity blockEntity = (BlockEntity)reference.get();
        if (blockEntity == null || blockEntity.m_58901_()) {
            REGISTRY.remove(insulatorId);
            return null;
        }
        return blockEntity;
    }

    public static void clear() {
        REGISTRY.clear();
    }

    private static int[] extractIds(BlockEntity blockEntity) {
        if (blockEntity instanceof UtilityPoleBlockEntity) {
            UtilityPoleBlockEntity pole = (UtilityPoleBlockEntity)blockEntity;
            return pole.getInsulatorIds();
        }
        if (blockEntity instanceof ElectricCabinBlockEntity) {
            ElectricCabinBlockEntity cabin = (ElectricCabinBlockEntity)blockEntity;
            return cabin.getInsulatorIds();
        }
        if (blockEntity instanceof PowerBoxBlockEntity) {
            PowerBoxBlockEntity powerBox = (PowerBoxBlockEntity)blockEntity;
            return powerBox.getInsulatorIds();
        }
        if (blockEntity instanceof WindTurbineBlockEntity) {
            WindTurbineBlockEntity turbine = (WindTurbineBlockEntity)blockEntity;
            return turbine.getInsulatorIds();
        }
        return null;
    }
}

