/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.electricity.client.wire;

import com.dooji.electricity.block.ElectricCabinBlock;
import com.dooji.electricity.block.PowerBoxBlock;
import com.dooji.electricity.block.UtilityPoleBlock;
import com.dooji.electricity.block.WindTurbineBlock;
import com.dooji.electricity.client.ElectricityClientConfig;
import com.dooji.electricity.client.render.obj.ObjRaycaster;
import com.dooji.electricity.wire.InsulatorPartHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class WireAnchorHelper {
    private WireAnchorHelper() {
    }

    public static Vec3 anchorOrFallback(BlockPos pos, String partName) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return Vec3.m_82512_((Vec3i)pos);
        }
        BlockEntity entity = mc.f_91073_.m_7702_(pos);
        Vec3 fallback = WireAnchorHelper.computeFallback(mc.f_91073_.m_8055_(pos), pos, partName);
        return WireAnchorHelper.anchorOrFallback(entity, partName, fallback);
    }

    public static Vec3 anchorOrFallback(BlockEntity entity, String partName, Vec3 fallback) {
        if (entity != null && ElectricityClientConfig.previewSnappingEnabled()) {
            return InsulatorPartHelper.resolve(entity, partName).map(InsulatorPartHelper.Insulator::anchor).orElse(fallback != null ? fallback : Vec3.m_82512_((Vec3i)entity.m_58899_()));
        }
        return fallback;
    }

    private static Vec3 computeFallback(BlockState state, BlockPos pos, String partName) {
        Direction facing = WireAnchorHelper.extractFacing(state);
        Vec3 partCenter = ObjRaycaster.getPartCenter(pos, partName, facing);
        if (partCenter != null) {
            return partCenter;
        }
        return Vec3.m_82512_((Vec3i)pos);
    }

    private static Direction extractFacing(BlockState state) {
        if (state == null) {
            return null;
        }
        if (state.m_61138_((Property)UtilityPoleBlock.FACING)) {
            return (Direction)state.m_61143_((Property)UtilityPoleBlock.FACING);
        }
        if (state.m_61138_((Property)ElectricCabinBlock.FACING)) {
            return (Direction)state.m_61143_((Property)ElectricCabinBlock.FACING);
        }
        if (state.m_61138_((Property)PowerBoxBlock.FACING)) {
            return (Direction)state.m_61143_((Property)PowerBoxBlock.FACING);
        }
        if (state.m_61138_((Property)WindTurbineBlock.FACING)) {
            return (Direction)state.m_61143_((Property)WindTurbineBlock.FACING);
        }
        return null;
    }
}

