/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.electricity.client.wire;

import com.dooji.electricity.block.ElectricCabinBlockEntity;
import com.dooji.electricity.block.PowerBoxBlockEntity;
import com.dooji.electricity.block.UtilityPoleBlockEntity;
import com.dooji.electricity.block.WindTurbineBlockEntity;
import com.dooji.electricity.client.wire.InsulatorLookup;
import com.dooji.electricity.main.wire.WireConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WireManagerClient {
    private static final Map<String, WireConnection> WIRE_CONNECTIONS = new ConcurrentHashMap<String, WireConnection>();
    private static final Map<Integer, Vec3> POSITION_CACHE = new ConcurrentHashMap<Integer, Vec3>();
    private static Vec3 pendingConnection = null;
    private static BlockPos pendingBlockPos = null;
    private static String pendingPartName = null;

    public static void sync(Collection<WireConnection> connections) {
        WIRE_CONNECTIONS.clear();
        POSITION_CACHE.clear();
        WireManagerClient.clearPendingConnection();
        if (connections == null) {
            return;
        }
        for (WireConnection connection : connections) {
            String key = connection.getStartInsulatorId() + "_" + connection.getEndInsulatorId();
            WIRE_CONNECTIONS.put(key, connection);
        }
    }

    public static void addWireConnection(WireConnection connection) {
        String key = connection.getStartInsulatorId() + "_" + connection.getEndInsulatorId();
        WIRE_CONNECTIONS.put(key, connection);
    }

    public static void removeWireConnection(WireConnection connection) {
        String key = connection.getStartInsulatorId() + "_" + connection.getEndInsulatorId();
        WIRE_CONNECTIONS.remove(key);
    }

    public static Collection<WireConnection> getAllWireConnections() {
        return new ArrayList<WireConnection>(WIRE_CONNECTIONS.values());
    }

    public static void removeAll() {
        WIRE_CONNECTIONS.clear();
        POSITION_CACHE.clear();
        WireManagerClient.clearPendingConnection();
    }

    public static void setPendingConnection(Vec3 pos) {
        pendingConnection = pos;
    }

    public static void setPendingConnection(Vec3 pos, BlockPos blockPos) {
        pendingConnection = pos;
        pendingBlockPos = blockPos;
    }

    public static void clearPendingConnection() {
        pendingConnection = null;
        pendingBlockPos = null;
        pendingPartName = null;
    }

    public static Vec3 getPendingConnection() {
        return pendingConnection;
    }

    public static BlockPos getPendingBlockPos() {
        return pendingBlockPos;
    }

    public static void setPendingPartName(String partName) {
        pendingPartName = partName;
    }

    public static String getPendingPartName() {
        return pendingPartName;
    }

    public static Vec3 getWirePosition(Level level, int insulatorId, BlockPos blockPos) {
        Vec3 resolved;
        if (insulatorId < 0) {
            return null;
        }
        Vec3 cached = POSITION_CACHE.get(insulatorId);
        if (cached != null) {
            return cached;
        }
        BlockEntity blockEntity = InsulatorLookup.get(insulatorId);
        if (blockEntity == null && level != null && blockPos != null && level.m_46805_(blockPos) && (blockEntity = level.m_7702_(blockPos)) != null) {
            InsulatorLookup.register(blockEntity);
        }
        if ((resolved = WireManagerClient.resolveInsulatorPosition(blockEntity, insulatorId)) != null) {
            POSITION_CACHE.put(insulatorId, resolved);
        }
        return resolved;
    }

    public static void invalidateInsulatorCache(int ... insulatorIds) {
        if (insulatorIds == null || insulatorIds.length == 0) {
            return;
        }
        for (int id : insulatorIds) {
            POSITION_CACHE.remove(id);
        }
    }

    private static Vec3 resolveInsulatorPosition(BlockEntity blockEntity, int insulatorId) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        if (blockEntity == null) {
                            return null;
                        }
                        if (!(blockEntity instanceof UtilityPoleBlockEntity)) break block5;
                        UtilityPoleBlockEntity pole = (UtilityPoleBlockEntity)blockEntity;
                        int[] ids = pole.getInsulatorIds();
                        for (int i = 0; i < ids.length; ++i) {
                            if (ids[i] != insulatorId) continue;
                            return pole.getWirePosition(i);
                        }
                        break block6;
                    }
                    if (!(blockEntity instanceof ElectricCabinBlockEntity)) break block7;
                    ElectricCabinBlockEntity cabin = (ElectricCabinBlockEntity)blockEntity;
                    int[] ids = cabin.getInsulatorIds();
                    for (int i = 0; i < ids.length; ++i) {
                        if (ids[i] != insulatorId) continue;
                        return cabin.getWirePosition(i);
                    }
                    break block6;
                }
                if (!(blockEntity instanceof PowerBoxBlockEntity)) break block8;
                PowerBoxBlockEntity powerBox = (PowerBoxBlockEntity)blockEntity;
                int[] ids = powerBox.getInsulatorIds();
                for (int i = 0; i < ids.length; ++i) {
                    if (ids[i] != insulatorId) continue;
                    return powerBox.getWirePosition(i);
                }
                break block6;
            }
            if (!(blockEntity instanceof WindTurbineBlockEntity)) break block6;
            WindTurbineBlockEntity turbine = (WindTurbineBlockEntity)blockEntity;
            int[] ids = turbine.getInsulatorIds();
            for (int i = 0; i < ids.length; ++i) {
                if (ids[i] != insulatorId) continue;
                return turbine.getWirePosition(i);
            }
        }
        return null;
    }
}

