/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.electricity.client.wire;

import net.minecraft.world.phys.Vec3;

public class WirePhysics {
    public static final float DEFLECTION_COEFFICIENT = 0.005f;
    public static final float LENGTH_COEFFICIENT = 0.02f;
    public static final float WIRE_SEGMENT_LENGTH = 1.0f;
    public static final float WIRE_RADIUS = 0.025f;

    public static Vec3 calculateDeflectionPoint(Vec3 start, Vec3 end, double progress) {
        Vec3 direction = end.m_82546_(start);
        double lx = Math.sqrt(direction.f_82479_ * direction.f_82479_ + direction.f_82481_ * direction.f_82481_);
        if (lx == 0.0) {
            return start.m_82549_(direction.m_82490_(progress));
        }
        double ly = direction.f_82480_;
        double alpha = (double)0.005f * (1.0 + (double)0.02f * lx);
        double a = lx > 0.0 ? (lx - ly / (alpha * lx)) / 2.0 : 0.0;
        double x = lx * progress;
        double y = alpha * (x * x - 2.0 * a * x);
        Vec3 result = start.m_82549_(new Vec3(direction.f_82479_ / lx * x, y, direction.f_82481_ / lx * x));
        return result;
    }

    public static Vec3 calculateTangent(Vec3 start, Vec3 end, double progress) {
        Vec3 direction = end.m_82546_(start);
        double lx = Math.sqrt(direction.f_82479_ * direction.f_82479_ + direction.f_82481_ * direction.f_82481_);
        if (lx == 0.0) {
            return direction.m_82541_();
        }
        double ly = direction.f_82480_;
        double alpha = (double)0.005f * (1.0 + (double)0.02f * lx);
        double a = lx > 0.0 ? (lx - ly / (alpha * lx)) / 2.0 : 0.0;
        double x = lx * progress;
        double slope = 2.0 * alpha * (x - a);
        return new Vec3(direction.f_82479_ / lx, slope, direction.f_82481_ / lx).m_82541_();
    }

    public static double calculateWireLength(Vec3 start, Vec3 end) {
        Vec3 direction = end.m_82546_(start);
        double lx = Math.sqrt(direction.f_82479_ * direction.f_82479_ + direction.f_82481_ * direction.f_82481_);
        if (lx == 0.0) {
            return Math.abs(direction.f_82480_);
        }
        double ly = direction.f_82480_;
        double alpha = (double)0.005f * (1.0 + (double)0.02f * lx);
        double a = lx > 0.0 ? (lx - ly / (alpha * lx)) / 2.0 : 0.0;
        double length = 0.0;
        for (double x = 0.0; x < lx; x += 1.0) {
            double slope = 2.0 * alpha * (x - a);
            double segmentLength = Math.sqrt(1.0 + slope * slope) * 1.0;
            length += segmentLength;
        }
        return length;
    }

    public static boolean shouldUseDeflection(Vec3 start, Vec3 end) {
        Vec3 direction = end.m_82546_(start);
        double horizontalDistance = Math.sqrt(direction.f_82479_ * direction.f_82479_ + direction.f_82481_ * direction.f_82481_);
        return horizontalDistance > 0.1;
    }

    public static float getYaw(Vec3 vec) {
        return (float)Math.toDegrees(Math.atan2(vec.f_82479_, vec.f_82481_));
    }

    public static float getPitch(Vec3 vec) {
        double xz = Math.sqrt(vec.f_82479_ * vec.f_82479_ + vec.f_82481_ * vec.f_82481_);
        return (float)Math.toDegrees(Math.atan2(vec.f_82480_, xz));
    }
}

