/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.electricity.client.wire;

import com.dooji.electricity.block.ElectricCabinBlockEntity;
import com.dooji.electricity.block.PowerBoxBlockEntity;
import com.dooji.electricity.block.UtilityPoleBlockEntity;
import com.dooji.electricity.block.WindTurbineBlockEntity;
import com.dooji.electricity.client.render.obj.ObjRaycaster;
import com.dooji.electricity.client.wire.WireAnchorHelper;
import com.dooji.electricity.client.wire.WireManagerClient;
import com.dooji.electricity.client.wire.WirePhysics;
import com.dooji.electricity.main.wire.WireConnection;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="electricity", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WireRenderer {
    private static final WireStyle ACTIVE_WIRE = new WireStyle(0, 0, 0, 255);
    private static final int FULL_BRIGHT = 0xF000F0;
    private static final double MIN_LENGTH = 0.1;
    private static final double WIRE_RADIUS = 0.025;
    private static final int WIRE_SIDES = 12;
    private static final int DEFLECTION_SIDES = 8;
    private static final double DEFLECTION_STEP = 0.25;
    private static final double SEGMENT_UNIT = 0.1;
    private static final ResourceLocation WIRE_TEXTURE = new ResourceLocation("minecraft", "block/black_wool");

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null || minecraft.f_91074_ == null) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        WireRenderer.renderAllWires(minecraft, poseStack);
    }

    public static void renderAllWires(Minecraft minecraft, PoseStack poseStack) {
        Collection<WireConnection> connections = WireManagerClient.getAllWireConnections();
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            return;
        }
        Vec3 cameraPos = minecraft.f_91063_.m_109153_().m_90583_();
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        for (WireConnection connection : connections) {
            WireRenderer.renderWire(level, connection, poseStack, (MultiBufferSource)bufferSource, cameraPos);
        }
        WireRenderer.renderWirePreview(minecraft, poseStack, (MultiBufferSource)bufferSource, cameraPos);
        bufferSource.m_109911_();
    }

    private static void renderWire(ClientLevel level, WireConnection connection, PoseStack poseStack, MultiBufferSource bufferSource, Vec3 cameraPos) {
        Vec3 startConnectionPoint = WireManagerClient.getWirePosition((Level)level, connection.getStartInsulatorId(), connection.getStartBlockPos());
        Vec3 endConnectionPoint = WireManagerClient.getWirePosition((Level)level, connection.getEndInsulatorId(), connection.getEndBlockPos());
        if (startConnectionPoint == null || endConnectionPoint == null) {
            return;
        }
        WireRenderer.renderWireSpan(startConnectionPoint, endConnectionPoint, cameraPos, poseStack, bufferSource, 0xF000F0, ACTIVE_WIRE);
    }

    private static void renderWirePreview(Minecraft minecraft, PoseStack poseStack, MultiBufferSource bufferSource, Vec3 cameraPos) {
        Vec3 pendingPos = WireManagerClient.getPendingConnection();
        if (pendingPos == null || minecraft.f_91074_ == null) {
            return;
        }
        Vec3 startConnectionPoint = pendingPos;
        Vec3 endConnectionPoint = WireRenderer.resolvePreviewEndpoint(minecraft, startConnectionPoint);
        if (endConnectionPoint == null) {
            return;
        }
        WireRenderer.renderWireSpan(startConnectionPoint, endConnectionPoint, cameraPos, poseStack, bufferSource, 0xF000F0, ACTIVE_WIRE);
    }

    private static void renderWireSpan(Vec3 start, Vec3 end, Vec3 cameraPos, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, WireStyle style) {
        if (start == null || end == null) {
            return;
        }
        Vec3 span = end.m_82546_(start);
        if (span.m_82556_() < 0.010000000000000002) {
            return;
        }
        poseStack.m_85836_();
        Vec3 viewStart = start.m_82546_(cameraPos);
        poseStack.m_85837_(viewStart.f_82479_, viewStart.f_82480_, viewStart.f_82481_);
        TextureAtlasSprite sprite = WireRenderer.getWireSprite();
        if (WirePhysics.shouldUseDeflection(start, end)) {
            WireRenderer.renderDeflectedSpan(Vec3.f_82478_, span, poseStack, bufferSource, packedLight, style, sprite);
        } else {
            WireRenderer.renderStraightSpan(Vec3.f_82478_, span, poseStack, bufferSource, packedLight, style, sprite);
        }
        poseStack.m_85849_();
    }

    private static void renderStraightSpan(Vec3 startVec, Vec3 endVec, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, WireStyle style, TextureAtlasSprite sprite) {
        Vec3 direction = endVec.m_82546_(startVec);
        double distance = direction.m_82553_();
        if (distance < 0.1) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(startVec.f_82479_, startVec.f_82480_, startVec.f_82481_);
        double yaw = Math.toDegrees(Math.atan2(direction.f_82479_, direction.f_82481_));
        double pitch = Math.toDegrees(Math.atan2(direction.f_82480_, Math.sqrt(direction.f_82479_ * direction.f_82479_ + direction.f_82481_ * direction.f_82481_)));
        poseStack.m_252781_(Axis.f_252436_.m_252977_((float)yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_((float)pitch));
        poseStack.m_85841_(1.0f, 1.0f, (float)distance);
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110451_());
        WireRenderer.emitCylinder(consumer, poseStack, packedLight, style, 0.025, 12, sprite);
        poseStack.m_85849_();
    }

    private static void renderDeflectedSpan(Vec3 startVec, Vec3 endVec, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, WireStyle style, TextureAtlasSprite sprite) {
        Vec3 direction = endVec.m_82546_(startVec);
        double lx = Math.sqrt(direction.f_82479_ * direction.f_82479_ + direction.f_82481_ * direction.f_82481_);
        if (lx < 0.1) {
            WireRenderer.renderStraightSpan(startVec, endVec, poseStack, bufferSource, packedLight, style, sprite);
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(startVec.f_82479_, startVec.f_82480_, startVec.f_82481_);
        double yaw = Math.toDegrees(Math.atan2(direction.f_82479_, direction.f_82481_));
        poseStack.m_252781_(Axis.f_252436_.m_252977_((float)yaw));
        double ly = direction.f_82480_;
        double alpha = (double)0.005f * (1.0 + (double)0.02f * lx);
        double a = lx > 0.0 ? (lx - ly / (alpha * lx)) / 2.0 : 0.0;
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110451_());
        double x = 0.0;
        while (x < lx) {
            double nextX = Math.min(x + 0.25, lx);
            double startY = alpha * (x * x - 2.0 * a * x);
            double endY = alpha * (nextX * nextX - 2.0 * a * nextX);
            double horizontalDistance = nextX - x;
            double verticalDistance = endY - startY;
            double actualSegmentDistance = Math.sqrt(horizontalDistance * horizontalDistance + verticalDistance * verticalDistance);
            double centerX = (x + nextX) * 0.5;
            double slope = 2.0 * alpha * (centerX - a);
            float pitchC = -((float)Math.toDegrees(Math.atan(slope)));
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, startY, x);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(pitchC + 90.0f));
            poseStack.m_85841_(1.0f, (float)(actualSegmentDistance / 0.1), 1.0f);
            WireRenderer.emitCylinderSegment(consumer, poseStack, packedLight, style, 0.025, 8, sprite);
            poseStack.m_85849_();
            x = nextX;
        }
        poseStack.m_85849_();
    }

    private static void emitCylinder(VertexConsumer consumer, PoseStack poseStack, int packedLight, WireStyle style, double wireRadius, int segments, TextureAtlasSprite sprite) {
        PoseStack.Pose pose = poseStack.m_85850_();
        float u0 = sprite.m_118367_(0.0);
        float u1 = sprite.m_118367_(16.0);
        float v0 = sprite.m_118393_(0.0);
        float v1 = sprite.m_118393_(16.0);
        for (int i = 0; i < segments; ++i) {
            double angle1 = Math.PI * 2 * (double)i / (double)segments;
            double angle2 = Math.PI * 2 * (double)(i + 1) / (double)segments;
            double x1 = Math.cos(angle1) * wireRadius;
            double y1 = Math.sin(angle1) * wireRadius;
            double x2 = Math.cos(angle2) * wireRadius;
            double y2 = Math.sin(angle2) * wireRadius;
            float nx1 = (float)(x1 / wireRadius);
            float ny1 = (float)(y1 / wireRadius);
            float nx2 = (float)(x2 / wireRadius);
            float ny2 = (float)(y2 / wireRadius);
            consumer.m_252986_(pose.m_252922_(), (float)x1, (float)y1, 0.0f).m_6122_(style.red, style.green, style.blue, style.alpha).m_7421_(u0, v0).m_7122_(0, 10).m_85969_(packedLight).m_252939_(pose.m_252943_(), nx1, ny1, 0.0f).m_5752_();
            consumer.m_252986_(pose.m_252922_(), (float)x1, (float)y1, 1.0f).m_6122_(style.red, style.green, style.blue, style.alpha).m_7421_(u0, v1).m_7122_(0, 10).m_85969_(packedLight).m_252939_(pose.m_252943_(), nx1, ny1, 0.0f).m_5752_();
            consumer.m_252986_(pose.m_252922_(), (float)x2, (float)y2, 1.0f).m_6122_(style.red, style.green, style.blue, style.alpha).m_7421_(u1, v1).m_7122_(0, 10).m_85969_(packedLight).m_252939_(pose.m_252943_(), nx2, ny2, 0.0f).m_5752_();
            consumer.m_252986_(pose.m_252922_(), (float)x2, (float)y2, 0.0f).m_6122_(style.red, style.green, style.blue, style.alpha).m_7421_(u1, v0).m_7122_(0, 10).m_85969_(packedLight).m_252939_(pose.m_252943_(), nx2, ny2, 0.0f).m_5752_();
        }
    }

    private static void emitCylinderSegment(VertexConsumer consumer, PoseStack poseStack, int packedLight, WireStyle style, double wireRadius, int segments, TextureAtlasSprite sprite) {
        PoseStack.Pose pose = poseStack.m_85850_();
        float u0 = sprite.m_118367_(0.0);
        float u1 = sprite.m_118367_(16.0);
        float v0 = sprite.m_118393_(0.0);
        float v1 = sprite.m_118393_(16.0);
        for (int i = 0; i < segments; ++i) {
            double angle1 = Math.PI * 2 * (double)i / (double)segments;
            double angle2 = Math.PI * 2 * (double)(i + 1) / (double)segments;
            double x1 = Math.cos(angle1) * wireRadius;
            double z1 = Math.sin(angle1) * wireRadius;
            double x2 = Math.cos(angle2) * wireRadius;
            double z2 = Math.sin(angle2) * wireRadius;
            float nx1 = (float)(x1 / wireRadius);
            float nz1 = (float)(z1 / wireRadius);
            float nx2 = (float)(x2 / wireRadius);
            float nz2 = (float)(z2 / wireRadius);
            consumer.m_252986_(pose.m_252922_(), (float)x1, 0.0f, (float)z1).m_6122_(style.red, style.green, style.blue, style.alpha).m_7421_(u0, v0).m_7122_(0, 10).m_85969_(packedLight).m_252939_(pose.m_252943_(), nx1, 0.0f, nz1).m_5752_();
            consumer.m_252986_(pose.m_252922_(), (float)x1, 0.1f, (float)z1).m_6122_(style.red, style.green, style.blue, style.alpha).m_7421_(u0, v1).m_7122_(0, 10).m_85969_(packedLight).m_252939_(pose.m_252943_(), nx1, 0.0f, nz1).m_5752_();
            consumer.m_252986_(pose.m_252922_(), (float)x2, 0.1f, (float)z2).m_6122_(style.red, style.green, style.blue, style.alpha).m_7421_(u1, v1).m_7122_(0, 10).m_85969_(packedLight).m_252939_(pose.m_252943_(), nx2, 0.0f, nz2).m_5752_();
            consumer.m_252986_(pose.m_252922_(), (float)x2, 0.0f, (float)z2).m_6122_(style.red, style.green, style.blue, style.alpha).m_7421_(u1, v0).m_7122_(0, 10).m_85969_(packedLight).m_252939_(pose.m_252943_(), nx2, 0.0f, nz2).m_5752_();
        }
    }

    private static TextureAtlasSprite getWireSprite() {
        return Minecraft.m_91087_().m_91304_().m_119428_(TextureAtlas.f_118259_).m_118316_(WIRE_TEXTURE);
    }

    private static Vec3 resolvePreviewEndpoint(Minecraft minecraft, Vec3 startPoint) {
        if (minecraft.f_91074_ == null) {
            return null;
        }
        Vec3 eyePosition = minecraft.f_91074_.m_20299_(1.0f);
        Vec3 lookDirection = minecraft.f_91074_.m_20154_();
        HitResult hitResult = minecraft.f_91077_;
        if (hitResult instanceof BlockHitResult) {
            Vec3 fallback;
            Vec3 anchor;
            String hoveredPart;
            BlockPos hitPos;
            BlockEntity blockEntity;
            BlockHitResult blockHit = (BlockHitResult)hitResult;
            if (minecraft.f_91073_ != null && WireRenderer.isWireAttachable(blockEntity = minecraft.f_91073_.m_7702_(hitPos = blockHit.m_82425_())) && (hoveredPart = ObjRaycaster.getHoveredPart(eyePosition, lookDirection, hitPos)) != null && (anchor = WireAnchorHelper.anchorOrFallback(blockEntity, hoveredPart, fallback = ObjRaycaster.getPartCenter(hitPos, hoveredPart))) != null && anchor.m_82557_(startPoint) > 0.010000000000000002) {
                return anchor;
            }
        }
        Vec3 playerPos = minecraft.f_91074_.m_20182_();
        Vec3 handPos = playerPos.m_82520_(0.0, (double)minecraft.f_91074_.m_20192_() * 0.5, 0.0);
        handPos = handPos.m_82549_(lookDirection.m_82490_(0.5));
        return handPos;
    }

    private static boolean isWireAttachable(BlockEntity blockEntity) {
        return blockEntity instanceof UtilityPoleBlockEntity || blockEntity instanceof ElectricCabinBlockEntity || blockEntity instanceof PowerBoxBlockEntity || blockEntity instanceof WindTurbineBlockEntity;
    }

    private record WireStyle(int red, int green, int blue, int alpha) {
    }
}

