/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.electricity.main;

import com.dooji.electricity.api.power.ElectricityCapabilities;
import com.dooji.electricity.block.ElectricCabinBlock;
import com.dooji.electricity.block.ElectricCabinBlockEntity;
import com.dooji.electricity.block.ElectricLampBlock;
import com.dooji.electricity.block.ElectricLampBlockEntity;
import com.dooji.electricity.block.PowerBoxBlock;
import com.dooji.electricity.block.PowerBoxBlockEntity;
import com.dooji.electricity.block.UtilityPoleBlock;
import com.dooji.electricity.block.UtilityPoleBlockEntity;
import com.dooji.electricity.block.WindTurbineBlock;
import com.dooji.electricity.block.WindTurbineBlockEntity;
import com.dooji.electricity.item.ItemWire;
import com.dooji.electricity.item.PowerWrenchItem;
import com.dooji.electricity.main.ElectricityServerConfig;
import com.dooji.electricity.main.network.ElectricityNetworking;
import com.dooji.electricity.main.power.PowerNetwork;
import com.dooji.electricity.main.weather.GlobalWeatherManager;
import com.dooji.electricity.main.wire.WireManager;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="electricity")
public class Electricity {
    public static final String MOD_ID = "electricity";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"electricity");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"electricity");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"electricity");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"electricity");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"electricity");
    public static final RegistryObject<Block> UTILITY_POLE_BLOCK = BLOCKS.register("utility_pole", () -> new UtilityPoleBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 10.0f).m_60955_()));
    public static final RegistryObject<Block> ELECTRIC_CABIN_BLOCK = BLOCKS.register("electric_cabin", () -> new ElectricCabinBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 10.0f).m_60955_()));
    public static final RegistryObject<Block> POWER_BOX_BLOCK = BLOCKS.register("power_box", () -> new PowerBoxBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 10.0f).m_60955_()));
    public static final RegistryObject<Block> WIND_TURBINE_BLOCK = BLOCKS.register("wind_turbine", () -> new WindTurbineBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 10.0f).m_60955_()));
    public static final RegistryObject<Block> ELECTRIC_LAMP_BLOCK = BLOCKS.register("electric_lamp", () -> new ElectricLampBlock(BlockBehaviour.Properties.m_284310_().m_60978_(0.3f).m_60955_()));
    public static final RegistryObject<Item> WIRE_ITEM = ITEMS.register("wire", ItemWire::new);
    public static final RegistryObject<Item> POWER_WRENCH_ITEM = ITEMS.register("power_wrench", PowerWrenchItem::new);
    public static final RegistryObject<Item> UTILITY_POLE_ITEM = ITEMS.register("utility_pole", () -> new BlockItem((Block)UTILITY_POLE_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<Item> ELECTRIC_CABIN_ITEM = ITEMS.register("electric_cabin", () -> new BlockItem((Block)ELECTRIC_CABIN_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<Item> POWER_BOX_ITEM = ITEMS.register("power_box", () -> new BlockItem((Block)POWER_BOX_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<Item> WIND_TURBINE_ITEM = ITEMS.register("wind_turbine", () -> new BlockItem((Block)WIND_TURBINE_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<Item> ELECTRIC_LAMP_ITEM = ITEMS.register("electric_lamp", () -> new BlockItem((Block)ELECTRIC_LAMP_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<CreativeModeTab> ELECTRICITY_TAB = CREATIVE_TABS.register("main", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.electricity.main")).m_257737_(() -> new ItemStack((ItemLike)WIRE_ITEM.get())).m_257501_((parameters, output) -> {
        output.m_246326_((ItemLike)POWER_WRENCH_ITEM.get());
        output.m_246326_((ItemLike)WIRE_ITEM.get());
        output.m_246326_((ItemLike)UTILITY_POLE_ITEM.get());
        output.m_246326_((ItemLike)ELECTRIC_CABIN_ITEM.get());
        output.m_246326_((ItemLike)POWER_BOX_ITEM.get());
        output.m_246326_((ItemLike)WIND_TURBINE_ITEM.get());
        output.m_246326_((ItemLike)ELECTRIC_LAMP_ITEM.get());
    }).m_257652_());
    public static RegistryObject<BlockEntityType<UtilityPoleBlockEntity>> UTILITY_POLE_BLOCK_ENTITY;
    public static RegistryObject<BlockEntityType<ElectricCabinBlockEntity>> ELECTRIC_CABIN_BLOCK_ENTITY;
    public static RegistryObject<BlockEntityType<PowerBoxBlockEntity>> POWER_BOX_BLOCK_ENTITY;
    public static RegistryObject<BlockEntityType<WindTurbineBlockEntity>> WIND_TURBINE_BLOCK_ENTITY;
    public static RegistryObject<BlockEntityType<ElectricLampBlockEntity>> ELECTRIC_LAMP_BLOCK_ENTITY;
    public static final WireManager wireManager;
    public static PowerNetwork powerNetwork;

    public Electricity() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        CREATIVE_TABS.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ElectricityServerConfig.spec(), "Electricity/server.toml");
        UTILITY_POLE_BLOCK_ENTITY = BLOCK_ENTITY_TYPES.register("utility_pole", () -> BlockEntityType.Builder.m_155273_(UtilityPoleBlockEntity::new, (Block[])new Block[]{(Block)UTILITY_POLE_BLOCK.get()}).m_58966_(null));
        ELECTRIC_CABIN_BLOCK_ENTITY = BLOCK_ENTITY_TYPES.register("electric_cabin", () -> BlockEntityType.Builder.m_155273_(ElectricCabinBlockEntity::new, (Block[])new Block[]{(Block)ELECTRIC_CABIN_BLOCK.get()}).m_58966_(null));
        POWER_BOX_BLOCK_ENTITY = BLOCK_ENTITY_TYPES.register("power_box", () -> BlockEntityType.Builder.m_155273_(PowerBoxBlockEntity::new, (Block[])new Block[]{(Block)POWER_BOX_BLOCK.get()}).m_58966_(null));
        WIND_TURBINE_BLOCK_ENTITY = BLOCK_ENTITY_TYPES.register("wind_turbine", () -> BlockEntityType.Builder.m_155273_(WindTurbineBlockEntity::new, (Block[])new Block[]{(Block)WIND_TURBINE_BLOCK.get()}).m_58966_(null));
        ELECTRIC_LAMP_BLOCK_ENTITY = BLOCK_ENTITY_TYPES.register("electric_lamp", () -> BlockEntityType.Builder.m_155273_(ElectricLampBlockEntity::new, (Block[])new Block[]{(Block)ELECTRIC_LAMP_BLOCK.get()}).m_58966_(null));
        BLOCK_ENTITY_TYPES.register(modEventBus);
        LOGGER.info("Registered {} items, {} blocks, and {} block entity types", new Object[]{ITEMS.getEntries().size(), BLOCKS.getEntries().size(), BLOCK_ENTITY_TYPES.getEntries().size()});
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(ElectricityCapabilities::register);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(ElectricityNetworking::init);
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        LOGGER.info("Electricity mod initialized on server");
        ServerLevel serverLevel = event.getServer().m_129783_();
        GlobalWeatherManager.get(serverLevel);
        wireManager.loadFromWorld(serverLevel);
        powerNetwork = new PowerNetwork(serverLevel, wireManager);
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            wireManager.sendAllWiresToPlayer(player2);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            for (ServerLevel level : event.getServer().m_129785_()) {
                GlobalWeatherManager.get(level).tick();
            }
            return;
        }
        if (powerNetwork != null) {
            powerNetwork.updatePowerNetwork();
        }
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        ServerLevel serverLevel = event.getServer().m_129783_();
        wireManager.forceSave(serverLevel);
        for (ServerLevel level : event.getServer().m_129785_()) {
            GlobalWeatherManager.clear(level);
        }
    }

    @SubscribeEvent
    public void onLevelUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            GlobalWeatherManager.clear(serverLevel);
        }
    }

    static {
        wireManager = new WireManager();
    }
}

