/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.electricity.main.network;

import com.dooji.electricity.block.UtilityPoleBlockEntity;
import com.dooji.electricity.client.ElectricityClient;
import com.dooji.electricity.main.Electricity;
import com.dooji.electricity.main.network.payloads.CreateWireFromInsulatorsPayload;
import com.dooji.electricity.main.network.payloads.PowerUpdatePayload;
import com.dooji.electricity.main.network.payloads.SyncWiresPayload;
import com.dooji.electricity.main.network.payloads.UpdateUtilityPoleConfigPayload;
import com.dooji.electricity.main.network.payloads.WireConnectionPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class ElectricityNetworking {
    private static final String PROTOCOL_VERSION = "1";
    public static final ResourceLocation NETWORK_CHANNEL = ResourceLocation.m_214293_((String)"electricity", (String)"main");
    public static SimpleChannel INSTANCE;

    public static void init() {
        INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)NETWORK_CHANNEL).networkProtocolVersion(() -> PROTOCOL_VERSION).clientAcceptedVersions(v -> true).serverAcceptedVersions(v -> true).simpleChannel();
        int id = 0;
        INSTANCE.messageBuilder(SyncWiresPayload.class, id++, NetworkDirection.PLAY_TO_CLIENT).encoder(SyncWiresPayload::write).decoder(SyncWiresPayload::read).consumerNetworkThread((msg, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            if (context.getDirection().getReceptionSide().isClient()) {
                context.enqueueWork(() -> ElectricityClient.handleSyncPacket(msg));
            }
            context.setPacketHandled(true);
        }).add();
        INSTANCE.messageBuilder(UpdateUtilityPoleConfigPayload.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(UpdateUtilityPoleConfigPayload::write).decoder(UpdateUtilityPoleConfigPayload::read).consumerNetworkThread((msg, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            if (context.getDirection().getReceptionSide().isServer()) {
                context.enqueueWork(() -> {
                    BlockPos pos;
                    ServerPlayer player = context.getSender();
                    if (player == null) {
                        return;
                    }
                    ServerLevel world = player.m_284548_();
                    if (!world.m_46805_(pos = msg.blockPos()) || !world.m_6857_().m_61937_(pos)) {
                        return;
                    }
                    if (!world.m_7966_((Player)player, pos)) {
                        return;
                    }
                    BlockEntity patt2702$temp = world.m_7702_(pos);
                    if (patt2702$temp instanceof UtilityPoleBlockEntity) {
                        UtilityPoleBlockEntity blockEntity = (UtilityPoleBlockEntity)patt2702$temp;
                        blockEntity.setOffsetX(msg.offsetX());
                        blockEntity.setOffsetY(msg.offsetY());
                        blockEntity.setOffsetZ(msg.offsetZ());
                        blockEntity.setYaw(msg.yaw());
                        blockEntity.setPitch(msg.pitch());
                    }
                });
            }
            context.setPacketHandled(true);
        }).add();
        INSTANCE.messageBuilder(CreateWireFromInsulatorsPayload.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(CreateWireFromInsulatorsPayload::write).decoder(CreateWireFromInsulatorsPayload::read).consumerNetworkThread((msg, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            if (context.getDirection().getReceptionSide().isServer()) {
                context.enqueueWork(() -> {
                    ServerPlayer player = context.getSender();
                    if (player == null) {
                        return;
                    }
                    Electricity.wireManager.createWireFromInsulators(player, (CreateWireFromInsulatorsPayload)msg);
                });
            }
            context.setPacketHandled(true);
        }).add();
        INSTANCE.messageBuilder(WireConnectionPayload.class, id++, NetworkDirection.PLAY_TO_CLIENT).encoder(WireConnectionPayload::write).decoder(WireConnectionPayload::read).consumerNetworkThread((msg, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            if (context.getDirection().getReceptionSide().isClient()) {
                context.enqueueWork(() -> ElectricityClient.handleWireConnectionPacket(msg));
            }
            context.setPacketHandled(true);
        }).add();
        INSTANCE.messageBuilder(PowerUpdatePayload.class, id++, NetworkDirection.PLAY_TO_CLIENT).encoder(PowerUpdatePayload::write).decoder(PowerUpdatePayload::read).consumerNetworkThread((msg, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            if (context.getDirection().getReceptionSide().isClient()) {
                context.enqueueWork(() -> ElectricityClient.handlePowerUpdatePacket(msg));
            }
            context.setPacketHandled(true);
        }).add();
    }

    public static void broadcastToAllClients(ServerLevel world, WireConnectionPayload payload) {
        INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)payload);
    }

    public static void sendToClient(ServerPlayer player, WireConnectionPayload payload) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)payload);
    }

    public static void sendToClient(ServerPlayer player, SyncWiresPayload payload) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)payload);
    }

    public static void sendPowerUpdate(ServerLevel world, BlockPos pos, double power) {
        INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> world.m_46745_(pos)), (Object)new PowerUpdatePayload(pos, power));
    }
}

